/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.node;

import com.vmware.vim.zeppelin.cr.auth.CRAccessControl;
import java.util.Date;
import java.util.Set;

public abstract class CRNode {
    public static final String NODE_TYPE_UNKNOWN = "UNKNOWN";
    public static final String NODE_TYPE_ROOT = "ROOT";
    public static final String NODE_TYPE_FOLDER = "FOLDER";
    public static final String NODE_TYPE_FILE = "FILE";
    private final CRNode _parentNode;
    private final String _nodeName;
    private final String _nodePath;
    private final Long _createTime;
    private final Set<CRAccessControl> _acls;
    public static String NODE_ROOT;
    public static String NODE_PATH_SEPARATOR;

    public CRNode(Long id, String nodeName, String nodePath, Date created, CRNode parentNode, Set<CRAccessControl> acls) {
        this._nodeName = nodeName;
        this._nodePath = nodePath;
        this._createTime = created != null ? Long.valueOf(created.getTime()) : null;
        this._parentNode = parentNode;
        this._acls = acls;
    }

    public static void setRootNodeChar(String ch) {
        NODE_ROOT = ch;
        NODE_PATH_SEPARATOR = ch;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public String getNodePath() {
        return this._nodePath;
    }

    public Date getCreateTime() {
        if (this._createTime == null) {
            return null;
        }
        Date result = new Date(this._createTime);
        return result;
    }

    public CRNode getParentNode() {
        return this._parentNode;
    }

    public Set<CRAccessControl> getAcls() {
        return this._acls;
    }

    public abstract String getNodeType();

    static {
        NODE_PATH_SEPARATOR = NODE_ROOT = "/";
    }
}

