/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.search;

import com.vmware.vim.zeppelin.cr.versionctrl.CRFileRevision;

public class CRSearchCriteria {
    public static String MODIFIER_EQUAL = "=";
    public static String MODIFIER_NOT_EQUAL = "!=";
    public static String MODIFIER_STR_CONTAINS = "contains";
    public static String MODIFIER_STR_BEGINSWITH = "beginsWith";
    public static String MODIFIER_STR_ENDSWITH = "endsWith";
    public static String NODE_NAME_FIELD = CRFileRevision.NODE_NAME_METADATA_KEY;
    public static String NODE_PATH_FIELD = CRFileRevision.NODE_PATH_METADATA_KEY;
    private String _field;
    private Object _value;
    private String _modifier;

    public void setField(String field) {
        this._field = field;
    }

    public String getField() {
        return this._field;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public Object getValue() {
        return this._value;
    }

    public void setModifier(String modifier) {
        this._modifier = modifier;
    }

    public String getModifier() {
        return this._modifier;
    }

    public boolean match(CRFileRevision rev) {
        boolean match = false;
        String val = rev.getFileMetaDataForKey(this._field);
        if (val != null) {
            if (this._modifier.equals(MODIFIER_EQUAL)) {
                match = val.equals(this._value);
            } else if (this._modifier.equals(MODIFIER_NOT_EQUAL)) {
                match = !val.equals(this._value);
            } else if (this._modifier.equals(MODIFIER_STR_BEGINSWITH)) {
                match = val.startsWith((String)this._value);
            } else if (this._modifier.equals(MODIFIER_STR_ENDSWITH)) {
                match = val.endsWith((String)this._value);
            } else if (this._modifier.equals(MODIFIER_STR_CONTAINS)) {
                match = val.contains((String)this._value);
            }
        }
        return match;
    }
}

