/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.search;

import com.vmware.vim.zeppelin.cr.search.CRSearchCriteria;
import com.vmware.vim.zeppelin.cr.versionctrl.CRFileRevision;
import java.util.HashSet;
import java.util.Set;

public class CRSearchQuery {
    public static String SEARCH_TYPE_ALL = "ALL";
    public static String SEARCH_TYPE_ANY = "ANY";
    private String _type = SEARCH_TYPE_ALL;
    private Set<CRSearchCriteria> _criteria = new HashSet<CRSearchCriteria>();

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public Set<CRSearchCriteria> getCriteria() {
        return this._criteria;
    }

    public void addCriteria(CRSearchCriteria criteria) {
        if (criteria != null) {
            this._criteria.add(criteria);
        }
    }

    public boolean match(CRFileRevision rev) {
        boolean match = false;
        if (rev != null) {
            if (this._criteria != null && this._criteria.size() > 0) {
                for (CRSearchCriteria crit : this._criteria) {
                    if (crit.match(rev)) {
                        match = true;
                        if (!this._type.equals(SEARCH_TYPE_ANY)) continue;
                    } else {
                        match = false;
                        if (!this._type.equals(SEARCH_TYPE_ALL)) continue;
                    }
                    break;
                }
            } else {
                match = true;
            }
        }
        return match;
    }
}

