/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.actions;

import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HostActionResolverPropertyProvider {
    private static final String RUNTIME_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private static final String RUNTIME_DAS_HOST_STATE_PROPERTY = "runtime.dasHostState";
    private static final String ASSOCIATED_HOST_PROFILE_PROPERTY = "associatedHostProfile";
    private static final String PARENT = "parent";
    private static final String PARENT_CONFIG_INFO_VM_SWAP_PLACEMENT = "configurationEx.vmSwapPlacement";
    private static final String CLUSTER_TYPE = ClusterComputeResource.class.getSimpleName();
    private QueryExecutor _queryExecutor;

    public HostActionResolverPropertyProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @PropertyProvider(value="HostSystem/isHostConnected")
    public List<Boolean> getIsHostConnected(Collection<ManagedObjectReference> hostRefs) throws Exception {
        Object[] arrayOfHostRefs = hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]);
        PropertyValue[] propValues = this._queryExecutor.getProperties(arrayOfHostRefs, new String[]{RUNTIME_CONNECTION_STATE_PROPERTY});
        Map<ManagedObjectReference, Boolean> hostConnectionStateByHost = this.getHostConnectionState(propValues);
        return this.createResultList(hostRefs, hostConnectionStateByHost);
    }

    @PropertyProvider(value="HostSystem/isEditVmStartupShutdownAllowed")
    public List<Boolean> getIsEditVmStartupShutdownAllowed(Collection<ManagedObjectReference> hostRefs) throws Exception {
        Object[] arrayOfHostRefs = hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]);
        PropertyValue[] propValues = this._queryExecutor.getProperties(arrayOfHostRefs, new String[]{RUNTIME_DAS_HOST_STATE_PROPERTY, RUNTIME_CONNECTION_STATE_PROPERTY});
        Map<ManagedObjectReference, Boolean> editVmStartupShutdownAllowedByHost = this.getEditVmStartupShutdownAllowed(propValues);
        return this.createResultList(hostRefs, editVmStartupShutdownAllowedByHost);
    }

    @PropertyProvider(value="HostSystem/isAttachedHostProfileAllow")
    public List<Boolean> getIsAttachedHostProfileAllow(Collection<ManagedObjectReference> hostRefs) throws Exception {
        Object[] arrayOfHostRefs = hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]);
        PropertyValue[] propValues = this._queryExecutor.getProperties(arrayOfHostRefs, new String[]{ASSOCIATED_HOST_PROFILE_PROPERTY, RUNTIME_CONNECTION_STATE_PROPERTY});
        Map<ManagedObjectReference, Boolean> resultByHost = this.getAttachToHostProfileAllowResult(propValues);
        return this.createResultList(hostRefs, resultByHost);
    }

    @PropertyProvider(value="HostSystem/isDetachedHostProfileAllow")
    public List<Boolean> getIsDetachedHostProfileAllow(Collection<ManagedObjectReference> hostRefs) throws Exception {
        Object[] arrayOfHostRefs = hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]);
        PropertyValue[] propValues = this._queryExecutor.getProperties(arrayOfHostRefs, new String[]{ASSOCIATED_HOST_PROFILE_PROPERTY, RUNTIME_CONNECTION_STATE_PROPERTY});
        Map<ManagedObjectReference, Boolean> resultByHost = this.getDetachToHostProfileAllowResult(propValues);
        return this.createResultList(hostRefs, resultByHost);
    }

    @PropertyProvider(value="HostSystem/isHostSwapfileLocationEditAllow")
    public List<Boolean> getIsHostSwapfileLocationEditAllow(Collection<ManagedObjectReference> hostRefs) throws Exception {
        PropertyValue[] propValues = this._queryExecutor.getProperties((Object[])hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]), new String[]{RUNTIME_CONNECTION_STATE_PROPERTY, PARENT});
        HashMap propValuesByHost = new HashMap();
        HashMap<ManagedObjectReference, PropertyValue> vmSwapPlacementPropertyValueByCluster = new HashMap<ManagedObjectReference, PropertyValue>();
        for (ManagedObjectReference hostRef : hostRefs) {
            propValuesByHost.put(hostRef, new HashMap());
        }
        for (PropertyValue propValue : propValues) {
            ((Map)propValuesByHost.get(propValue.resourceObject)).put(propValue.propertyName, propValue);
        }
        ArrayList<ManagedObjectReference> parentClusterRefs = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference hostRef : hostRefs) {
            PropertyValue parentPropValue = (PropertyValue)((Map)propValuesByHost.get(hostRef)).get(PARENT);
            ManagedObjectReference parentRef = null;
            if (parentPropValue != null && parentPropValue.value != null) {
                parentRef = (ManagedObjectReference)parentPropValue.value;
            }
            if (parentRef == null || !parentRef.getType().equals(CLUSTER_TYPE)) continue;
            parentClusterRefs.add((ManagedObjectReference)parentPropValue.value);
        }
        if (!parentClusterRefs.isEmpty()) {
            PropertyValue[] propValuesForClusters;
            for (PropertyValue propValue : propValuesForClusters = this._queryExecutor.getProperties((Object[])parentClusterRefs.toArray(new ManagedObjectReference[parentClusterRefs.size()]), new String[]{PARENT_CONFIG_INFO_VM_SWAP_PLACEMENT})) {
                vmSwapPlacementPropertyValueByCluster.put((ManagedObjectReference)propValue.resourceObject, propValue);
            }
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (ManagedObjectReference hostRef : hostRefs) {
            PropertyValue connStatePropValue = (PropertyValue)((Map)propValuesByHost.get(hostRef)).get(RUNTIME_CONNECTION_STATE_PROPERTY);
            if (connStatePropValue == null || !this.isHostConnected(connStatePropValue.value).booleanValue()) {
                result.add(false);
                continue;
            }
            PropertyValue parentPropValue = (PropertyValue)((Map)propValuesByHost.get(hostRef)).get(PARENT);
            if (parentPropValue == null || !(parentPropValue.value instanceof ManagedObjectReference)) {
                result.add(false);
                continue;
            }
            ManagedObjectReference parentObject = (ManagedObjectReference)parentPropValue.value;
            if (!parentObject.getType().equals(CLUSTER_TYPE)) {
                result.add(true);
                continue;
            }
            PropertyValue parentClusterSwapPlacementPropValue = (PropertyValue)vmSwapPlacementPropertyValueByCluster.get(parentObject);
            if (parentClusterSwapPlacementPropValue == null) {
                result.add(false);
                continue;
            }
            result.add(!ConfigInfo.SwapPlacementType.vmDirectory.name().equals(parentClusterSwapPlacementPropValue.value));
        }
        return result;
    }

    private List<Boolean> createResultList(Collection<ManagedObjectReference> hostRefs, Map<ManagedObjectReference, Boolean> resultByHost) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (ManagedObjectReference hostRef : hostRefs) {
            if (!resultByHost.containsKey(hostRef)) {
                result.add(Boolean.FALSE);
                continue;
            }
            result.add(resultByHost.get(hostRef));
        }
        return result;
    }

    private Map<ManagedObjectReference, Boolean> getAttachToHostProfileAllowResult(PropertyValue[] properties) {
        return this.getMergedResultWithConnectionState(ASSOCIATED_HOST_PROFILE_PROPERTY, properties, true);
    }

    private Map<ManagedObjectReference, Boolean> getDetachToHostProfileAllowResult(PropertyValue[] properties) {
        return this.getMergedResultWithConnectionState(ASSOCIATED_HOST_PROFILE_PROPERTY, properties, false);
    }

    private Map<ManagedObjectReference, Boolean> getEditVmStartupShutdownAllowed(PropertyValue[] properties) {
        return this.getMergedResultWithConnectionState(RUNTIME_DAS_HOST_STATE_PROPERTY, properties, true);
    }

    private Map<ManagedObjectReference, Boolean> getMergedResultWithConnectionState(String propertyName, PropertyValue[] properties, boolean checkIsNull) {
        HashMap<ManagedObjectReference, Boolean> result = new HashMap<ManagedObjectReference, Boolean>();
        if (properties == null) {
            return result;
        }
        for (PropertyValue propValue : properties) {
            Boolean newValue;
            ManagedObjectReference moRef = (ManagedObjectReference)propValue.resourceObject;
            if (RUNTIME_CONNECTION_STATE_PROPERTY.equals(propValue.propertyName)) {
                Boolean hostConnectionState = this.isHostConnected(propValue.value);
                newValue = this.calculateNewValue(hostConnectionState, (Boolean)result.get(moRef));
                result.put(moRef, newValue);
            }
            if (!propertyName.equals(propValue.propertyName)) continue;
            Boolean propertyValueResult = checkIsNull ? Boolean.valueOf(propValue.value == null) : Boolean.valueOf(propValue.value != null);
            newValue = this.calculateNewValue(propertyValueResult, (Boolean)result.get(moRef));
            result.put(moRef, newValue);
        }
        return result;
    }

    private Boolean calculateNewValue(Boolean newValue, Boolean oldValue) {
        if (oldValue == null) {
            return newValue;
        }
        return oldValue != false && newValue != false;
    }

    private Map<ManagedObjectReference, Boolean> getHostConnectionState(PropertyValue[] properties) {
        HashMap<ManagedObjectReference, Boolean> result = new HashMap<ManagedObjectReference, Boolean>();
        if (properties == null) {
            return result;
        }
        for (PropertyValue propValue : properties) {
            ManagedObjectReference moRef = (ManagedObjectReference)propValue.resourceObject;
            Boolean isHostConnected = this.isHostConnected(propValue.value);
            result.put(moRef, isHostConnected);
        }
        return result;
    }

    private Boolean isHostConnected(Object hostConnectionState) {
        Boolean isConnected = false;
        if (hostConnectionState instanceof HostSystem.ConnectionState) {
            HostSystem.ConnectionState connectionState = (HostSystem.ConnectionState)hostConnectionState;
            isConnected = connectionState == HostSystem.ConnectionState.connected;
        }
        return isConnected;
    }
}

