/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.hardware.ciminfo;

import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.host.hardware.ciminfo.CimMessageReader;
import com.vmware.vsphere.client.host.hardware.ciminfo.model.Sensor;
import com.vmware.vsphere.client.host.hardware.ciminfo.model.SensorDetails;
import com.vmware.vsphere.client.host.hardware.ciminfo.model.SensorGroup;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.SensorDetailsFactory;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.SensorDetailsTypeFactory;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.SensorValueParser;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.types.SensorConstants;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SensorFactory {
    private static final Log logger = LogFactory.getLog(SensorFactory.class);

    public SensorGroup createSensorGroup(Node groupNode, int sensorGroupId) {
        Element element = (Element)groupNode;
        String name = element.getAttribute(SensorConstants.Details.NAME.getLabel());
        if (StringUtil.isNullOrEmpty((String)name)) {
            logger.warn((Object)("Missing group name for " + groupNode.getNodeName()));
            name = groupNode.getNodeName();
        }
        SensorGroup sensorGroupNode = new SensorGroup();
        String status = element.getAttribute(SensorConstants.Details.HEALTH_STATE.getValue());
        sensorGroupNode.id = Integer.toString(sensorGroupId);
        sensorGroupNode.sensorType = name.toLowerCase();
        sensorGroupNode.name = this.getGroupName(sensorGroupNode.sensorType);
        sensorGroupNode.setStatus(status);
        return sensorGroupNode;
    }

    public Sensor createSensor(Node node, int sensorId, String sensorType, String parentId) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        Sensor sensor = new Sensor();
        String reading = null;
        String baseUnit = null;
        String rateUnit = null;
        String modifier = "1";
        boolean isNumericSensor = this.isNumericSensor(node);
        ArrayList<SensorDetails> details = new ArrayList<SensorDetails>();
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            block10: for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName == null) continue;
                SensorConstants.Details property = SensorConstants.Details.findByValue(nodeName);
                switch (property) {
                    case NAME: {
                        if (sensor.name != null) continue block10;
                        sensor.name = childNode.getTextContent();
                        continue block10;
                    }
                    case ELEMENT_NAME: {
                        sensor.name = childNode.getTextContent();
                        continue block10;
                    }
                    case HEALTH_STATE: {
                        sensor.setStatus(childNode.getTextContent());
                        continue block10;
                    }
                    case CURRENT_READING: {
                        reading = childNode.getTextContent();
                        continue block10;
                    }
                    case BASE_UNITS: {
                        baseUnit = this.parseBaseUnitLabel(childNode.getTextContent());
                        continue block10;
                    }
                    case RATE_UNITS: {
                        rateUnit = this.parseRateUnitLabel(childNode.getTextContent());
                        continue block10;
                    }
                    case UNIT_MODIFIER: {
                        modifier = childNode.getTextContent();
                        continue block10;
                    }
                    case WHITE_SPACE: {
                        continue block10;
                    }
                    default: {
                        SensorDetails detail = this.parseDetails(childNode);
                        if (detail == null) continue block10;
                        details.add(detail);
                    }
                }
            }
        }
        sensor.id = Integer.toString(sensorId);
        sensor.parentId = parentId;
        sensor.sensorType = sensorType;
        sensor.reading = this.getSensorReading(reading, isNumericSensor, baseUnit, rateUnit, modifier);
        if (details.size() > 0) {
            sensor.details = details;
        }
        return sensor;
    }

    private String getSensorReading(String value, boolean isNumericSensor, String baseUnit, String rateUnit, String modifier) {
        if (value == null || !isNumericSensor) {
            return value;
        }
        return this.convertValue(value, baseUnit, rateUnit, modifier);
    }

    private String convertValue(String value, String baseUnit, String rateUnit, String modifier) {
        String newValue = new SensorValueParser().parseValueWithModifier(value, modifier);
        newValue = newValue + (StringUtils.isNotEmpty((String)baseUnit) ? " " + baseUnit : "");
        newValue = newValue + (StringUtils.isNotEmpty((String)rateUnit) ? " " + rateUnit : "");
        return newValue;
    }

    private String parseBaseUnitLabel(String value) {
        return CimMessageReader.getName("baseunits_" + value);
    }

    private String parseRateUnitLabel(String value) {
        return CimMessageReader.getName("rateunits_" + value);
    }

    private boolean isNumericSensor(Node node) {
        return SensorConstants.Types.NUMERIC_SENSOR.getValue().equals(node.getNodeName());
    }

    private SensorDetails parseDetails(Node node) {
        SensorDetailsFactory detailsFactory = SensorDetailsTypeFactory.getDetailsFactory(node);
        SensorDetails sensorDetails = detailsFactory.parseDetails();
        return sensorDetails;
    }

    private String getGroupName(String key) {
        return CimMessageReader.getName("group_" + key);
    }
}

