/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.hardware.ciminfo;

import com.vmware.vsphere.client.host.hardware.ciminfo.DateParserAndFormatter;
import com.vmware.vsphere.client.host.hardware.ciminfo.model.SystemEventData;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.types.SensorConstants;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceEventLogFactory {
    public SystemEventData createSystemEventData(Node node) {
        SystemEventData systemEventLogRecord = null;
        if (node != null) {
            String id = node.getAttributes().getNamedItem("key").getNodeValue();
            String eventMessage = "";
            String rawTimestamp = "";
            NodeList childNodes = node.getChildNodes();
            if (childNodes != null && childNodes.getLength() > 0) {
                block4: for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node childNode = childNodes.item(i);
                    SensorConstants.Details property = SensorConstants.Details.findByValue(childNode.getNodeName());
                    switch (property) {
                        case LOG_RECORD_CAPTION: {
                            eventMessage = childNode.getTextContent();
                            continue block4;
                        }
                        case LOG_RECORD_TIMESTAMP: {
                            rawTimestamp = childNode.getTextContent();
                            continue block4;
                        }
                    }
                }
            }
            String formattedTimestamp = new DateParserAndFormatter(rawTimestamp).parseAndFormat();
            systemEventLogRecord = new SystemEventData(id, eventMessage, formattedTimestamp);
        }
        return systemEventLogRecord;
    }
}

