/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.hardware.ciminfo.model;

import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.host.hardware.ciminfo.CimMessageReader;
import com.vmware.vsphere.client.host.hardware.ciminfo.model.SensorStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum HealthStatus {
    HEALTH_STATUS_OK("5", "normal"),
    HEALTH_STATUS_WARNING("10", "warning"),
    HEALTH_STATUS_UNKNOWN("0", "unknown"),
    HEALTH_STATUS_ALERT("15", "alert"),
    HEALTH_STATUS_NOT_DEFINED("", "");

    private static final Log _logger;
    private static final int MIN_ALERT_LEVEL = 15;
    private String value;
    private SensorStatus sensorStatus;

    private HealthStatus(String value, String statusKey) {
        this.value = value;
        String statusMessage = this.getStatusMessage(statusKey);
        this.sensorStatus = new SensorStatus(statusKey, statusMessage);
    }

    public SensorStatus getSensorStatus() {
        return this.sensorStatus;
    }

    public boolean isNormal() {
        return this != HEALTH_STATUS_WARNING && this != HEALTH_STATUS_ALERT;
    }

    public static HealthStatus getHealthStatus(String value) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            return HEALTH_STATUS_NOT_DEFINED;
        }
        for (HealthStatus status : HealthStatus.values()) {
            if (!status.value.equals(value)) continue;
            return status;
        }
        try {
            int reading = Integer.parseInt(value);
            if (reading >= 15) {
                return HEALTH_STATUS_ALERT;
            }
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Unknown health status: " + value));
        }
        return HEALTH_STATUS_UNKNOWN;
    }

    private String getStatusMessage(String statusKey) {
        return StringUtil.isNullOrEmpty((String)statusKey) ? "" : CimMessageReader.getMessage(statusKey);
    }

    static {
        _logger = LogFactory.getLog(HealthStatus.class);
    }
}

