/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.hardware.ciminfo.model;

import com.vmware.vsphere.client.host.hardware.ciminfo.model.HealthStatus;
import com.vmware.vsphere.client.host.hardware.ciminfo.model.SensorDetails;
import com.vmware.vsphere.client.host.hardware.ciminfo.model.SensorStatus;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.annotate.JsonIgnore;

public class Sensor
implements Cloneable {
    private static final Log logger = LogFactory.getLog(Sensor.class);
    public String id;
    public String parentId;
    public String name;
    public String sensorType;
    public String reading;
    public List<SensorDetails> details;
    public HealthStatus healthStatus = HealthStatus.HEALTH_STATUS_NOT_DEFINED;

    public List<SensorStatus> getStatus() {
        return Collections.singletonList(this.healthStatus.getSensorStatus());
    }

    public void setStatus(String value) {
        this.healthStatus = HealthStatus.getHealthStatus(value);
    }

    @JsonIgnore
    public boolean hasAlert() {
        return HealthStatus.HEALTH_STATUS_ALERT == this.healthStatus;
    }

    @JsonIgnore
    public boolean hasWarning() {
        return HealthStatus.HEALTH_STATUS_WARNING == this.healthStatus;
    }

    public Sensor clone() {
        Sensor result = null;
        try {
            Sensor duplicateSensor = (Sensor)super.clone();
            duplicateSensor.healthStatus = this.healthStatus;
            result = duplicateSensor;
        }
        catch (CloneNotSupportedException ex) {
            logger.error((Object)"Cannot clone sensor", (Throwable)ex);
        }
        return result;
    }

    public String toString() {
        String info = "Id: " + this.id + "\n" + "Parent id:" + this.parentId + "\n" + "Name: " + this.name + "\n" + "Sensor type: " + this.sensorType + "\n" + "Reading: " + this.reading;
        if (this.details != null && this.details.size() > 0) {
            info = info + "\nHas details";
            for (SensorDetails detail : this.details) {
                info = info + detail.toString();
            }
        } else {
            info = info + "\nNo details";
        }
        info = info + "\n";
        return info;
    }
}

