/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.hardware.ciminfo.model;

import com.vmware.vsphere.client.host.hardware.ciminfo.CimMessageReader;
import com.vmware.vsphere.client.host.hardware.ciminfo.model.HealthStatus;
import com.vmware.vsphere.client.host.hardware.ciminfo.model.Sensor;
import com.vmware.vsphere.client.host.hardware.ciminfo.model.SensorStatus;
import java.util.ArrayList;
import java.util.List;

public class SensorGroup
extends Sensor {
    private int alertCount;
    private int warningCount;

    @Override
    public List<SensorStatus> getStatus() {
        String statusMessage;
        ArrayList<SensorStatus> statuses = new ArrayList<SensorStatus>();
        if (this.alertCount == 0 && this.warningCount == 0) {
            statuses.add(this.healthStatus.getSensorStatus());
            return statuses;
        }
        if (this.alertCount > 0) {
            String alertStatus = HealthStatus.HEALTH_STATUS_ALERT.getSensorStatus().status;
            statusMessage = this.getAlertsMessage(this.alertCount);
            SensorStatus alertStatusGroup = new SensorStatus(alertStatus, statusMessage);
            statuses.add(alertStatusGroup);
        }
        if (this.warningCount > 0) {
            String warningStatus = HealthStatus.HEALTH_STATUS_WARNING.getSensorStatus().status;
            statusMessage = this.getWarningsMessage(this.warningCount);
            SensorStatus warningStatusGroup = new SensorStatus(warningStatus, statusMessage);
            statuses.add(warningStatusGroup);
        }
        return statuses;
    }

    public void updateStatus(Sensor sensor) {
        if (sensor.hasWarning()) {
            ++this.warningCount;
        } else if (sensor.hasAlert()) {
            ++this.alertCount;
        }
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getAlertCount() {
        return this.alertCount;
    }

    private String getWarningsMessage(int count) {
        if (count == 1) {
            return CimMessageReader.getMessage("oneWarning");
        }
        return CimMessageReader.getMessage("nWarnings", String.valueOf(count));
    }

    private String getAlertsMessage(int count) {
        if (count == 1) {
            return CimMessageReader.getMessage("oneAlert");
        }
        return CimMessageReader.getMessage("nAlerts", String.valueOf(count));
    }
}

