/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details;

import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.DefaultSensorDetailsFactory;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.SensorUnit;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.types.SensorConstants;
import org.w3c.dom.Node;

class MemorySensorDetailsFactory
extends DefaultSensorDetailsFactory {
    private static final String MEMORY_LABEL = "memory";

    MemorySensorDetailsFactory(Node node) {
        super(node);
    }

    @Override
    protected String parseValue() {
        String parsedValue;
        String propertyLabel = this.getPropertyLabel();
        SensorConstants.Details property = SensorConstants.Details.findByLabel(propertyLabel);
        String rawValue = super.parseValue();
        switch (property) {
            case CAPACITY: {
                parsedValue = this.valueParser.parseCapacity(rawValue);
                break;
            }
            case MEMORY_SPEED: 
            case MAX_MEMORY_SPEED: 
            case SPEED: {
                parsedValue = this.valueParser.parseClockSpeed(rawValue);
                break;
            }
            case OPERATIONAL_STATUS: {
                String operationalStatusPrefix = SensorConstants.Details.OPERATIONAL_STATUS.getLabel();
                parsedValue = this.valueParser.parseKeyValue(operationalStatusPrefix, rawValue);
                break;
            }
            case MEMORY_TYPE: 
            case FORM_FACTOR: {
                String formFactorPrefix = this.parseFullLabelKey();
                parsedValue = this.valueParser.parseKeyValue(formFactorPrefix, rawValue);
                break;
            }
            default: {
                parsedValue = rawValue;
            }
        }
        return parsedValue;
    }

    @Override
    protected String parseUnitKey() {
        SensorUnit unit;
        String propertyLabel = this.getPropertyLabel();
        SensorConstants.Details property = SensorConstants.Details.findByLabel(propertyLabel);
        String rawValue = super.parseValue();
        switch (property) {
            case CAPACITY: {
                unit = this.unitParser.getMemoryUnit(rawValue);
                break;
            }
            case MAX_MEMORY_SPEED: 
            case SPEED: {
                unit = this.unitParser.getClockSpeedUnit(rawValue);
                break;
            }
            default: {
                unit = SensorUnit.NO_UNIT;
            }
        }
        return unit.getUnitLabel();
    }

    @Override
    protected String getTypePrefix() {
        return MEMORY_LABEL;
    }
}

