/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details;

import com.vmware.vsphere.client.host.hardware.ciminfo.CimMessageReader;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.DefaultSensorDetailsFactory;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.SensorUnit;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.types.SensorConstants;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NumericSensorDetailsFactory
extends DefaultSensorDetailsFactory {
    private static final String NUMERIC_SENSOR_LABEL = "other";

    NumericSensorDetailsFactory(Node node) {
        super(node);
    }

    @Override
    protected String parseValue() {
        String parsedValue;
        String propertyLabel = this.getPropertyLabel();
        SensorConstants.Details property = SensorConstants.Details.findByLabel(propertyLabel);
        String rawValue = super.parseValue();
        switch (property) {
            case LOWER_THRESHOLD_NON_CRITICAL: 
            case UPPER_THRESHOLD_NON_CRITICAL: 
            case LOWER_THRESHOLD_CRITICAL: 
            case UPPER_THRESHOLD_CRITICAL: 
            case LOWER_THRESHOLD_FATAL: 
            case UPPER_THRESHOLD_FATAL: {
                parsedValue = this.parseValueByType(rawValue);
                break;
            }
            default: {
                parsedValue = rawValue;
            }
        }
        return parsedValue;
    }

    private String parseValueByType(String rawValue) {
        String modifier = this.getModifier();
        String parsedValue = this.valueParser.parseValueWithModifier(rawValue, modifier);
        return parsedValue;
    }

    private String getModifier() {
        NodeList childNodes = this.node.getParentNode().getChildNodes();
        String modifier = "1";
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            String itemName = item.getNodeName();
            if (!SensorConstants.Details.UNIT_MODIFIER.getValue().equals(itemName)) continue;
            modifier = item.getTextContent();
            break;
        }
        return modifier;
    }

    @Override
    protected String parseUnitKey() {
        String baseUnit;
        String propertyLabel = this.getPropertyLabel();
        SensorConstants.Details property = SensorConstants.Details.findByLabel(propertyLabel);
        switch (property) {
            case LOWER_THRESHOLD_NON_CRITICAL: 
            case UPPER_THRESHOLD_NON_CRITICAL: 
            case LOWER_THRESHOLD_CRITICAL: 
            case UPPER_THRESHOLD_CRITICAL: 
            case LOWER_THRESHOLD_FATAL: 
            case UPPER_THRESHOLD_FATAL: {
                String unitId = this.getBaseUnit();
                baseUnit = this.getBaseUnit(unitId);
                break;
            }
            default: {
                baseUnit = SensorUnit.NO_UNIT.getUnitLabel();
            }
        }
        return baseUnit;
    }

    private String getBaseUnit() {
        NodeList childNodes = this.node.getParentNode().getChildNodes();
        String unit = "1";
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            String itemName = item.getNodeName();
            if (!SensorConstants.Details.BASE_UNITS.getValue().equals(itemName)) continue;
            unit = item.getTextContent();
            break;
        }
        return unit;
    }

    private String getBaseUnit(String index) {
        String fullKey = "baseunits_" + index;
        return CimMessageReader.getName(fullKey);
    }

    @Override
    protected String getTypePrefix() {
        return NUMERIC_SENSOR_LABEL;
    }
}

