/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details;

import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.DefaultSensorDetailsFactory;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.types.SensorConstants;
import org.w3c.dom.Node;

class PciDeviceSensorDetailsFactory
extends DefaultSensorDetailsFactory {
    private static final String PCI_LABEL_PREFIX = "pci";

    PciDeviceSensorDetailsFactory(Node node) {
        super(node);
    }

    @Override
    protected String parseValue() {
        String parsedValue;
        String propertyLabel = this.getPropertyLabel();
        SensorConstants.Details property = SensorConstants.Details.findByLabel(propertyLabel);
        String rawValue = super.parseValue();
        switch (property) {
            case CAPABILITIES: {
                String keyPrefix = this.parseFullLabelKey();
                parsedValue = this.valueParser.parseKeyValue(keyPrefix, rawValue);
                break;
            }
            case VENDOR_ID: 
            case PCI_DEVICE_ID: 
            case SUBSYSTEM_ID: 
            case SUBSYSTEM_VENDOR_ID: {
                parsedValue = this.valueParser.parseHexadecimal(rawValue);
                break;
            }
            default: {
                parsedValue = rawValue;
            }
        }
        return parsedValue;
    }

    @Override
    protected String getTypePrefix() {
        return PCI_LABEL_PREFIX;
    }
}

