/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details;

import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.DefaultSensorDetailsFactory;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.types.SensorConstants;
import org.w3c.dom.Node;

class PowerSensorDetailsFactory
extends DefaultSensorDetailsFactory {
    private static final String POWER_PREFIX = "power";

    PowerSensorDetailsFactory(Node node) {
        super(node);
    }

    @Override
    protected String parseValue() {
        String parsedValue;
        String propertyLabel = this.getPropertyLabel();
        SensorConstants.Details property = SensorConstants.Details.findByLabel(propertyLabel);
        String rawValue = super.parseValue();
        switch (property) {
            case TOTAL_OUTPUT_POWER: {
                parsedValue = this.parseTotalOutputPower(rawValue);
                break;
            }
            default: {
                parsedValue = rawValue;
            }
        }
        return parsedValue;
    }

    private String parseTotalOutputPower(String rawValue) {
        String parsedValue;
        if ("0".equals(rawValue)) {
            String keyPrefix = this.parseFullLabelKey();
            parsedValue = this.valueParser.parseKeyValue(keyPrefix, rawValue);
        } else {
            parsedValue = rawValue;
        }
        return parsedValue;
    }

    @Override
    protected String getTypePrefix() {
        return POWER_PREFIX;
    }
}

