/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details;

import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.DefaultSensorDetailsFactory;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.SensorUnit;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.types.SensorConstants;
import org.w3c.dom.Node;

class ProcessorSensorDetailsFactory
extends DefaultSensorDetailsFactory {
    private static final String PROCESSOR_LABEL = "processor";

    ProcessorSensorDetailsFactory(Node node) {
        super(node);
    }

    @Override
    protected String parseValue() {
        String parsedValue;
        String propertyLabel = this.getPropertyLabel();
        SensorConstants.Details property = SensorConstants.Details.findByLabel(propertyLabel);
        String rawValue = super.parseValue();
        switch (property) {
            case OPERATIONAL_STATUS: {
                String keyPrefix = SensorConstants.Details.OPERATIONAL_STATUS.getLabel();
                parsedValue = this.valueParser.parseKeyValue(keyPrefix, rawValue);
                break;
            }
            case LEVEL: 
            case CACHE_TYPE: 
            case WRITE_POLICY: 
            case READ_POLICY: 
            case ASSOCIATIVITY: 
            case CPU_STATUS: 
            case FAMILY: {
                String keyPrefix = this.parseFullLabelKey();
                parsedValue = this.valueParser.parseKeyValue(keyPrefix, rawValue);
                break;
            }
            case CURRENT_CLOCK_SPEED: 
            case MAX_CLOCK_SPEED: 
            case EXTERNAL_BUS_CLOCK_SPEED: {
                parsedValue = this.valueParser.parseClockSpeed(rawValue);
                break;
            }
            default: {
                parsedValue = rawValue;
            }
        }
        return parsedValue;
    }

    @Override
    protected String parseUnitKey() {
        SensorUnit unit;
        String propertyLabel = this.getPropertyLabel();
        SensorConstants.Details property = SensorConstants.Details.findByLabel(propertyLabel);
        String rawValue = super.parseValue();
        switch (property) {
            case CURRENT_CLOCK_SPEED: 
            case MAX_CLOCK_SPEED: 
            case EXTERNAL_BUS_CLOCK_SPEED: {
                unit = this.unitParser.getClockSpeedUnit(rawValue);
                break;
            }
            case DATA_WIDTH: {
                unit = SensorUnit.BITS;
                break;
            }
            default: {
                unit = SensorUnit.NO_UNIT;
            }
        }
        return unit.getUnitLabel();
    }

    @Override
    protected String getTypePrefix() {
        return PROCESSOR_LABEL;
    }
}

