/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details;

import com.vmware.vsphere.client.host.hardware.ciminfo.DateParserAndFormatter;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.details.DefaultSensorDetailsFactory;
import com.vmware.vsphere.client.host.hardware.ciminfo.sensors.types.SensorConstants;
import org.w3c.dom.Node;

class SoftwareIdentitySensorDetailsFactory
extends DefaultSensorDetailsFactory {
    private static final String SOFTWARE_IDENTITY_LABEL = "software";

    SoftwareIdentitySensorDetailsFactory(Node node) {
        super(node);
    }

    @Override
    protected String parseValue() {
        String parsedValue;
        String propertyLabel = this.getPropertyLabel();
        SensorConstants.Details property = SensorConstants.Details.findByLabel(propertyLabel);
        String rawValue = super.parseValue();
        switch (property) {
            case RELEASE_DATE: 
            case INSTALL_DATE: {
                parsedValue = new DateParserAndFormatter(rawValue).parseAndFormat();
                break;
            }
            default: {
                parsedValue = rawValue;
            }
        }
        return parsedValue;
    }

    @Override
    protected String getTypePrefix() {
        return SOFTWARE_IDENTITY_LABEL;
    }
}

