/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ProviderSummaryData;
import com.vmware.vsphere.client.host.util.HostFormatUtil;
import java.util.ArrayList;
import java.util.List;

@QueryBinding(value="HostSystem")
public final class HostSummaryData
extends ProviderSummaryData {
    private final String VENDOR_PATTERN_DELL = "Dell";
    private final String VENDOR_PATTERN_IBM = "IBM";
    private final String VENDOR_PATTERN_HP = "HP";
    private final String VENDOR_PATTERN_FUJITSU = "Fujitsu";
    @Property(value="HostSystem/summary/rebootRequired")
    public boolean rebootRequired;
    @Property(value="HostSystem/summary/gateway/gatewayType")
    private String gatewayType;
    @Property(value="HostSystem/config/product/name")
    private String productName;
    @Property(value="HostSystem/config/product/version")
    private String productVersion;
    @Property(value="HostSystem/config/product/build")
    private String productBuild;
    @Property(value="HostSystem/hardware/systemInfo/vendor")
    private String vendor;
    @Property(value="HostSystem/hardware/systemInfo/model")
    private String model;
    @Property(value="HostSystem/summary/hardware/cpuModel")
    private String cpuModel;
    @Property(value="HostSystem/hardware/cpuInfo/numCpuThreads")
    private int logicalCpuCount;
    @Property(value="HostSystem/summary/config/vmotionEnabled")
    private boolean vmotionEnabled;
    @Property(value="HostSystem/summary/config/faultToleranceEnabled")
    private boolean ftEnabled;
    @Property(value="HostSystem/summary/currentEVCModeKey")
    private String currentEVCMode;
    @Property(value="HostSystem/summary/hardware/numNics")
    private int nicCount;
    @Property(value="HostSystem/allNormalVMOrPrimaryFTVM/length")
    private int vmCount;
    @Property(value="HostSystem/powerState")
    private HostSystem.PowerState powerState;
    @Property(value="HostSystem/connectionState")
    private HostSystem.ConnectionState connectionState;
    @Property(value="HostSystem/runtime/inMaintenanceMode")
    private boolean inMaintenanceMode;
    @Property(value="HostSystem/summary/quickStats/uptime")
    private int uptimeInSeconds;

    public BaseSummaryData.LabelValue[] getSummaryItems() {
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("summaryView.hypervisor", (Object)this.getHypervisor()), new BaseSummaryData.LabelValue("summaryView.modelLabel", (Object)this.model), new BaseSummaryData.LabelValue("summaryView.cpuTypeLabel", (Object)this.cpuModel), new BaseSummaryData.LabelValue("summaryView.cpuCountLabel", (Object)this.logicalCpuCount), new BaseSummaryData.LabelValue("summaryView.nicCountLabel", (Object)this.nicCount), new BaseSummaryData.LabelValue("summaryView.vmCountLabel", (Object)this.vmCount), new BaseSummaryData.LabelValue("summaryView.stateLabel", (Object)HostFormatUtil.formatHostConnectionState(this.connectionState, this.inMaintenanceMode, this.powerState)), new BaseSummaryData.LabelValue("summaryView.uptimeLabel", (Object)HostFormatUtil.formatUptime(this.uptimeInSeconds))};
    }

    public BaseSummaryData.Badge[] getBadges() {
        ArrayList<BaseSummaryData.Badge> result = new ArrayList<BaseSummaryData.Badge>();
        result.addAll(this.getVendorBadge());
        if (this.ftEnabled) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-ftEnabled", "summaryView.badge.ft", false));
        }
        if (this.vmotionEnabled) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-vMotionEnabled", "summaryView.badge.vmotion", false));
        }
        if (!StringUtil.isNullOrEmpty((String)this.currentEVCMode)) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-evcEnabled24", "badge.evcEnabled", false));
        }
        return result.toArray(new BaseSummaryData.Badge[result.size()]);
    }

    private List<BaseSummaryData.Badge> getVendorBadge() {
        ArrayList<BaseSummaryData.Badge> result = new ArrayList<BaseSummaryData.Badge>();
        if (!StringUtil.isNullOrEmpty((String)this.vendor)) {
            if (this.vendor.contains("Dell")) {
                result.add(new BaseSummaryData.Badge("icon-vSphere-vendorDell", this.vendor, true));
            } else if (this.vendor.contains("IBM")) {
                result.add(new BaseSummaryData.Badge("icon-vSphere-vendorIbm", this.vendor, true));
            } else if (this.vendor.contains("HP")) {
                result.add(new BaseSummaryData.Badge("icon-vSphere-vendorHp", this.vendor, true));
            } else if (this.vendor.contains("Fujitsu")) {
                result.add(new BaseSummaryData.Badge("icon-vSphere-vendorFujitsu", this.vendor, true));
            }
        }
        return result;
    }

    private String getHypervisor() {
        if (!StringUtil.isNullOrEmpty((String)this.gatewayType)) {
            return HostFormatUtil.formatHypervisorType(this.gatewayType);
        }
        return String.format("%s, %s, %s", this.productName, this.productVersion, this.productBuild);
    }
}

