/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.util;

import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.Ruleset;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vsphere.client.host.model.FirewallConnection;
import com.vmware.vsphere.client.host.model.FirewallConnectionDirectionInfo;
import com.vmware.vsphere.client.host.util.HostStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class FirewallInfoConverter {
    private static final String PORT_RANGE_KEY = "firewallConnection.portRange";
    private static final String PORTS_WITH_PROTOCOL_KEY = "firewallConnection.portsWithProtocol";
    private static final String NETWORK_WITH_MASK_KEY = "firewallConnection.networkWithMask";
    private static final String DELIMITER_KEY = "firewallConnection.delimiter";

    public static FirewallConnection[] toFirewallConnections(FirewallInfo firewallInfo, ServiceInfo serviceInfo) {
        if (firewallInfo == null || ArrayUtil.isNullOrEmpty((Object[])firewallInfo.ruleset)) {
            return new FirewallConnection[0];
        }
        ArrayList<FirewallConnection> result = new ArrayList<FirewallConnection>();
        Map<String, Boolean> daemonStatuses = FirewallInfoConverter.getDaemonStatuses(serviceInfo);
        for (Ruleset ruleset : firewallInfo.ruleset) {
            result.add(FirewallInfoConverter.getServiceConnections(ruleset, daemonStatuses.get(ruleset.service)));
        }
        return result.toArray(new FirewallConnection[result.size()]);
    }

    private static Map<String, Boolean> getDaemonStatuses(ServiceInfo serviceInfo) {
        HashMap<String, Boolean> daemonsStatuses = new HashMap<String, Boolean>();
        if (serviceInfo != null) {
            for (Service service : serviceInfo.getService()) {
                daemonsStatuses.put(service.getKey(), service.isRunning());
            }
        }
        return daemonsStatuses;
    }

    private static FirewallConnection getServiceConnections(Ruleset ruleset, Boolean daemonStatus) {
        FirewallConnection connection = new FirewallConnection();
        connection.serviceName = ruleset.label;
        connection.serviceKey = ruleset.key;
        connection.enabled = ruleset.enabled;
        connection.ipList = FirewallInfoConverter.getFormattedIpAddresses(ruleset.getAllowedHosts());
        connection.rawIpList = ruleset.getAllowedHosts();
        connection.daemonStatus = daemonStatus;
        HashMap<Ruleset.Rule.Protocol, Set<Pair<Integer, Integer>>> inPorts = new HashMap<Ruleset.Rule.Protocol, Set<Pair<Integer, Integer>>>();
        HashMap<Ruleset.Rule.Protocol, Set<Pair<Integer, Integer>>> outPorts = new HashMap<Ruleset.Rule.Protocol, Set<Pair<Integer, Integer>>>();
        inPorts.put(Ruleset.Rule.Protocol.tcp, new HashSet());
        inPorts.put(Ruleset.Rule.Protocol.udp, new HashSet());
        outPorts.put(Ruleset.Rule.Protocol.tcp, new HashSet());
        outPorts.put(Ruleset.Rule.Protocol.udp, new HashSet());
        if (ruleset.rule != null) {
            block4: for (Ruleset.Rule rule : ruleset.rule) {
                switch (rule.direction) {
                    case inbound: {
                        ((Set)inPorts.get(Ruleset.Rule.Protocol.valueOf((String)rule.protocol))).add(FirewallInfoConverter.getPortRange(rule));
                        continue block4;
                    }
                    case outbound: {
                        ((Set)outPorts.get(Ruleset.Rule.Protocol.valueOf((String)rule.protocol))).add(FirewallInfoConverter.getPortRange(rule));
                    }
                }
            }
        }
        connection.inboundDirectionInfo = FirewallInfoConverter.createDirectionInfo(inPorts, Ruleset.Rule.Direction.inbound);
        connection.outboundDirectionInfo = FirewallInfoConverter.createDirectionInfo(outPorts, Ruleset.Rule.Direction.outbound);
        return connection;
    }

    private static Pair<Integer, Integer> getPortRange(Ruleset.Rule rule) {
        Pair portRange = rule.endPort == null ? new Pair((Object)rule.port, (Object)rule.port) : new Pair((Object)rule.port, (Object)rule.endPort);
        return portRange;
    }

    private static String getFormattedIpAddresses(Ruleset.IpList ipList) {
        if (ipList == null) {
            return new String();
        }
        if (ipList.allIp) {
            return HostStringUtil.getString("firewallConnection.allIp");
        }
        ArrayList<String> ipAddresses = new ArrayList<String>();
        if (!ArrayUtil.isNullOrEmpty((Object[])ipList.ipAddress)) {
            ipAddresses.addAll(Arrays.asList(ipList.ipAddress));
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])ipList.ipNetwork)) {
            for (Ruleset.IpNetwork netRule : ipList.ipNetwork) {
                String subnet = HostStringUtil.getString(NETWORK_WITH_MASK_KEY, netRule.network, String.valueOf(netRule.prefixLength));
                ipAddresses.add(subnet);
            }
        }
        return StringUtils.join(ipAddresses, (String)HostStringUtil.getString(DELIMITER_KEY));
    }

    private static FirewallConnectionDirectionInfo createDirectionInfo(Map<Ruleset.Rule.Protocol, Set<Pair<Integer, Integer>>> ports, Ruleset.Rule.Direction direction) {
        FirewallConnectionDirectionInfo directionInfo = new FirewallConnectionDirectionInfo();
        directionInfo.direction = FirewallInfoConverter.localizeDirection(direction);
        directionInfo.rawTcpPorts = FirewallInfoConverter.getSortedPorts(ports.get(Ruleset.Rule.Protocol.tcp));
        directionInfo.rawUdpPorts = FirewallInfoConverter.getSortedPorts(ports.get(Ruleset.Rule.Protocol.udp));
        directionInfo.tcpPorts = FirewallInfoConverter.getFormattedPorts(directionInfo.rawTcpPorts);
        directionInfo.udpPorts = FirewallInfoConverter.getFormattedPorts(directionInfo.rawUdpPorts);
        directionInfo.combinedPorts = FirewallInfoConverter.getCombinedFormattedPorts(directionInfo.rawTcpPorts, directionInfo.rawUdpPorts);
        return directionInfo;
    }

    private static String getCombinedFormattedPorts(List<Pair<Integer, Integer>> tcpPorts, List<Pair<Integer, Integer>> udpPorts) {
        String formattedUdpPorts;
        ArrayList<String> formattedPortsList = new ArrayList<String>();
        String formattedTcpPorts = FirewallInfoConverter.getFormattedPorts(tcpPorts);
        if (formattedTcpPorts.length() > 0) {
            formattedPortsList.add(HostStringUtil.getString(PORTS_WITH_PROTOCOL_KEY, formattedTcpPorts, FirewallInfoConverter.localizeProtocol(Ruleset.Rule.Protocol.tcp)));
        }
        if ((formattedUdpPorts = FirewallInfoConverter.getFormattedPorts(udpPorts)).length() > 0) {
            formattedPortsList.add(HostStringUtil.getString(PORTS_WITH_PROTOCOL_KEY, formattedUdpPorts, FirewallInfoConverter.localizeProtocol(Ruleset.Rule.Protocol.udp)));
        }
        return StringUtils.join(formattedPortsList, (String)HostStringUtil.getString(DELIMITER_KEY));
    }

    private static String getFormattedPorts(List<Pair<Integer, Integer>> ports) {
        ArrayList<String> formattedPortsList = new ArrayList<String>();
        for (Pair<Integer, Integer> portRange : ports) {
            if (((Integer)portRange.first).equals(portRange.second)) {
                formattedPortsList.add(((Integer)portRange.first).toString());
                continue;
            }
            formattedPortsList.add(HostStringUtil.getString(PORT_RANGE_KEY, ((Integer)portRange.first).toString(), ((Integer)portRange.second).toString()));
        }
        return StringUtils.join(formattedPortsList, (String)HostStringUtil.getString(DELIMITER_KEY));
    }

    private static List<Pair<Integer, Integer>> getSortedPorts(Set<Pair<Integer, Integer>> ports) {
        ArrayList<Pair<Integer, Integer>> sortedPorts = new ArrayList<Pair<Integer, Integer>>(ports);
        Collections.sort(sortedPorts, new Comparator<Pair<Integer, Integer>>(){

            @Override
            public int compare(Pair<Integer, Integer> o1, Pair<Integer, Integer> o2) {
                if ((Integer)o1.first < (Integer)o2.first) {
                    return -1;
                }
                if ((Integer)o2.first < (Integer)o1.first) {
                    return 1;
                }
                if ((Integer)o1.second < (Integer)o2.second) {
                    return -1;
                }
                if ((Integer)o2.second < (Integer)o1.second) {
                    return 1;
                }
                return 0;
            }
        });
        return sortedPorts;
    }

    private static String localizeProtocol(Ruleset.Rule.Protocol protocol) {
        switch (protocol) {
            case tcp: {
                return HostStringUtil.getString("firewallConnection.tcp");
            }
            case udp: {
                return HostStringUtil.getString("firewallConnection.udp");
            }
        }
        return "";
    }

    private static String localizeDirection(Ruleset.Rule.Direction direction) {
        switch (direction) {
            case inbound: {
                return HostStringUtil.getString("firewallConnection.incoming");
            }
            case outbound: {
                return HostStringUtil.getString("firewallConnection.outgoing");
            }
        }
        return "";
    }
}

