/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.applmgmt;

import com.vmware.appliance.access.ShellTypes;
import com.vmware.appliance.networking.InterfacesTypes;
import com.vmware.appliance.networking.dns.ServersTypes;
import com.vmware.appliance.techpreview.ShutdownTypes;
import com.vmware.appliance.techpreview.networking.Ipv4Types;
import com.vmware.appliance.techpreview.networking.Ipv6Types;
import com.vmware.appliance.techpreview.networking.RoutesTypes;
import com.vmware.appliance.techpreview.networking.firewall.addr.InboundTypes;
import com.vmware.vise.vim.cloudvm.DnsServerConfig;
import com.vmware.vise.vim.cloudvm.FirewallAddressRule;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.IPv6Address;
import com.vmware.vise.vim.cloudvm.IPv6Config;
import com.vmware.vise.vim.cloudvm.NetworkInterfaceInfo;
import com.vmware.vise.vim.cloudvm.NetworkRoute;
import com.vmware.vise.vim.cloudvm.PowerOperationConfig;
import com.vmware.vise.vim.cloudvm.ShellConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class VapiToXmlRpcConverter {
    VapiToXmlRpcConverter() {
    }

    static ShellTypes.ShellConfig toVapiStruct(ShellConfig shellConfig) {
        ShellTypes.ShellConfig shellConfig2 = new ShellTypes.ShellConfig();
        shellConfig2.setTimeout((long)shellConfig.timeout);
        shellConfig2.setEnabled(shellConfig.enabled);
        return shellConfig2;
    }

    static ShellConfig fromVapiStruct(ShellTypes.ShellConfig shellConfig) {
        ShellConfig shellConfig2 = new ShellConfig();
        shellConfig2.timeout = (int)shellConfig.getTimeout();
        shellConfig2.enabled = shellConfig.getEnabled();
        return shellConfig2;
    }

    static String[] toStringArray(List<String> list) {
        if (list == null) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    static DnsServerConfig fromVapiStruct(ServersTypes.DNSServerConfig dNSServerConfig) {
        DnsServerConfig dnsServerConfig = new DnsServerConfig();
        dnsServerConfig.mode = dNSServerConfig.getMode().getEnumValue() == ServersTypes.DNSServerMode.Values.dhcp ? DnsServerConfig.Mode.DHCP : DnsServerConfig.Mode.STATIC;
        dnsServerConfig.servers = dNSServerConfig.getServers().toArray(new String[dNSServerConfig.getServers().size()]);
        return dnsServerConfig;
    }

    static NetworkInterfaceInfo fromVapiStruct(InterfacesTypes.InterfaceInfo interfaceInfo) {
        NetworkInterfaceInfo networkInterfaceInfo = new NetworkInterfaceInfo();
        networkInterfaceInfo.mac = interfaceInfo.getMac();
        networkInterfaceInfo.name = interfaceInfo.getName();
        networkInterfaceInfo.status = interfaceInfo.getStatus() == InterfacesTypes.InterfaceStatus.down ? NetworkInterfaceInfo.NetworkInterfaceStatus.DOWN : NetworkInterfaceInfo.NetworkInterfaceStatus.UP;
        return networkInterfaceInfo;
    }

    static ServersTypes.DNSServerConfig toVapiStruct(DnsServerConfig dnsServerConfig) {
        ServersTypes.DNSServerConfig dNSServerConfig = new ServersTypes.DNSServerConfig();
        dNSServerConfig.setServers(Arrays.asList(dnsServerConfig.servers));
        dNSServerConfig.setMode(dnsServerConfig.mode == DnsServerConfig.Mode.DHCP ? ServersTypes.DNSServerMode.dhcp : ServersTypes.DNSServerMode.is_static);
        return dNSServerConfig;
    }

    static NetworkInterfaceInfo[] fromVapiList(List<InterfacesTypes.InterfaceInfo> list) {
        if (list == null) {
            return null;
        }
        NetworkInterfaceInfo[] networkInterfaceInfoArray = new NetworkInterfaceInfo[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            networkInterfaceInfoArray[i] = VapiToXmlRpcConverter.fromVapiStruct(list.get(i));
        }
        return networkInterfaceInfoArray;
    }

    static List<String> toVapiList(String[] stringArray) {
        return Arrays.asList(stringArray);
    }

    static IPv4Config[] fromVapiIpv4List(List<Ipv4Types.IPv4ConfigReadOnly> list) {
        if (list == null) {
            return null;
        }
        IPv4Config[] iPv4ConfigArray = new IPv4Config[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            iPv4ConfigArray[i] = VapiToXmlRpcConverter.fromVapiStruct(list.get(i));
        }
        return iPv4ConfigArray;
    }

    static List<Ipv4Types.IPv4Config> toVapiIpv4List(IPv4Config[] iPv4ConfigArray) {
        ArrayList<Ipv4Types.IPv4Config> arrayList = new ArrayList<Ipv4Types.IPv4Config>();
        if (iPv4ConfigArray != null) {
            for (IPv4Config iPv4Config : iPv4ConfigArray) {
                arrayList.add(VapiToXmlRpcConverter.toVapiStruct(iPv4Config));
            }
        }
        return arrayList;
    }

    private static Ipv4Types.IPv4Config toVapiStruct(IPv4Config iPv4Config) {
        Ipv4Types.IPv4Config iPv4Config2 = new Ipv4Types.IPv4Config();
        String string = iPv4Config.address == null ? "" : iPv4Config.address;
        iPv4Config2.setAddress(string);
        String string2 = iPv4Config.defaultGateway == null ? "" : iPv4Config.defaultGateway;
        iPv4Config2.setDefaultGateway(string2);
        iPv4Config2.setInterfaceName(iPv4Config.nic);
        iPv4Config2.setPrefix((long)iPv4Config.prefix);
        iPv4Config2.setMode(VapiToXmlRpcConverter.toVapiMode(iPv4Config.mode));
        return iPv4Config2;
    }

    static IPv4Config fromVapiStruct(Ipv4Types.IPv4ConfigReadOnly iPv4ConfigReadOnly) {
        IPv4Config iPv4Config = new IPv4Config();
        iPv4Config.address = iPv4ConfigReadOnly.getAddress();
        iPv4Config.defaultGateway = iPv4ConfigReadOnly.getDefaultGateway();
        iPv4Config.nic = iPv4ConfigReadOnly.getInterfaceName();
        iPv4Config.prefix = (int)iPv4ConfigReadOnly.getPrefix();
        iPv4Config.mode = VapiToXmlRpcConverter.fromVapiMode(iPv4ConfigReadOnly.getMode());
        iPv4Config.updateable = iPv4ConfigReadOnly.getUpdateable();
        return iPv4Config;
    }

    private static Ipv4Types.IPv4Mode toVapiMode(IPv4Config.Ipv4Mode ipv4Mode) {
        switch (ipv4Mode) {
            case DHCP: {
                return Ipv4Types.IPv4Mode.dhcp;
            }
            case STATIC: {
                return Ipv4Types.IPv4Mode.is_static;
            }
            case UNCONFIGURED: {
                return Ipv4Types.IPv4Mode.unconfigured;
            }
        }
        throw new IllegalStateException();
    }

    private static IPv4Config.Ipv4Mode fromVapiMode(Ipv4Types.IPv4Mode iPv4Mode) {
        switch (iPv4Mode.getEnumValue()) {
            case dhcp: {
                return IPv4Config.Ipv4Mode.DHCP;
            }
            case is_static: {
                return IPv4Config.Ipv4Mode.STATIC;
            }
            case unconfigured: {
                return IPv4Config.Ipv4Mode.UNCONFIGURED;
            }
        }
        return null;
    }

    static IPv6Config[] fromVapiIpv6ConfigList(List<Ipv6Types.IPv6ConfigReadOnly> list) {
        if (list == null) {
            return null;
        }
        IPv6Config[] iPv6ConfigArray = new IPv6Config[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            iPv6ConfigArray[i] = VapiToXmlRpcConverter.fromVapiStruct(list.get(i));
        }
        return iPv6ConfigArray;
    }

    static IPv6Config fromVapiStruct(Ipv6Types.IPv6ConfigReadOnly iPv6ConfigReadOnly) {
        IPv6Config iPv6Config = new IPv6Config();
        iPv6Config.addresses = VapiToXmlRpcConverter.fromVapiIpv6AddressList(iPv6ConfigReadOnly.getAddresses());
        iPv6Config.nic = iPv6ConfigReadOnly.getInterfaceName();
        iPv6Config.dhcp = iPv6ConfigReadOnly.getDhcp();
        iPv6Config.updateable = iPv6ConfigReadOnly.getUpdateable();
        iPv6Config.defaultGateway = iPv6ConfigReadOnly.getDefaultGateway();
        iPv6Config.autoconf = iPv6ConfigReadOnly.getAutoconf();
        return iPv6Config;
    }

    static List<Ipv6Types.IPv6Config> toVapiIpv6List(IPv6Config[] iPv6ConfigArray) {
        if (iPv6ConfigArray == null) {
            return new ArrayList<Ipv6Types.IPv6Config>();
        }
        ArrayList<Ipv6Types.IPv6Config> arrayList = new ArrayList<Ipv6Types.IPv6Config>();
        for (IPv6Config iPv6Config : iPv6ConfigArray) {
            arrayList.add(VapiToXmlRpcConverter.toVapiStruct(iPv6Config));
        }
        return arrayList;
    }

    private static Ipv6Types.IPv6Config toVapiStruct(IPv6Config iPv6Config) {
        Ipv6Types.IPv6Config iPv6Config2 = new Ipv6Types.IPv6Config();
        iPv6Config2.setInterfaceName(iPv6Config.nic);
        iPv6Config2.setDefaultGateway(iPv6Config.defaultGateway);
        iPv6Config2.setDhcp(iPv6Config.dhcp);
        iPv6Config2.setAutoconf(iPv6Config.autoconf);
        iPv6Config2.setAddresses(VapiToXmlRpcConverter.toVapiAddressListReadonly(iPv6Config.addresses));
        return iPv6Config2;
    }

    private static List<Ipv6Types.IPv6Address> toVapiAddressListReadonly(IPv6Address[] iPv6AddressArray) {
        Ipv6Types.IPv6Address[] iPv6AddressArray2 = new Ipv6Types.IPv6Address[iPv6AddressArray.length];
        for (int i = 0; i < iPv6AddressArray2.length; ++i) {
            iPv6AddressArray2[i] = new Ipv6Types.IPv6Address();
            iPv6AddressArray2[i].setPrefix((long)iPv6AddressArray[i].prefix);
            iPv6AddressArray2[i].setAddress(iPv6AddressArray[i].address);
        }
        return Arrays.asList(iPv6AddressArray2);
    }

    static IPv6Address[] fromVapiIpv6AddressList(List<Ipv6Types.IPv6AddressReadOnly> list) {
        IPv6Address[] iPv6AddressArray = new IPv6Address[list.size()];
        for (int i = 0; i < iPv6AddressArray.length; ++i) {
            iPv6AddressArray[i] = new IPv6Address();
            iPv6AddressArray[i].address = list.get(i).getAddress();
            iPv6AddressArray[i].prefix = (int)list.get(i).getPrefix();
            iPv6AddressArray[i].origin = VapiToXmlRpcConverter.fromVapiOrigin(list.get(i).getOrigin());
            iPv6AddressArray[i].status = VapiToXmlRpcConverter.fromVapiStatus(list.get(i).getStatus());
        }
        return iPv6AddressArray;
    }

    private static IPv6Address.Ipv6Status fromVapiStatus(Ipv6Types.IPv6AddressStatus iPv6AddressStatus) {
        switch (iPv6AddressStatus.getEnumValue()) {
            case deprecated: {
                return IPv6Address.Ipv6Status.DEPRECATED;
            }
            case duplicate: {
                return IPv6Address.Ipv6Status.DUPLICATE;
            }
            case inaccessible: {
                return IPv6Address.Ipv6Status.INACCESSIBLE;
            }
            case invalid: {
                return IPv6Address.Ipv6Status.INVALID;
            }
            case optimistic: {
                return IPv6Address.Ipv6Status.OPTIMISTIC;
            }
            case preferred: {
                return IPv6Address.Ipv6Status.PREFERRED;
            }
            case tentative: {
                return IPv6Address.Ipv6Status.TENTATIVE;
            }
        }
        return IPv6Address.Ipv6Status.UNKNOWN;
    }

    private static IPv6Address.Ipv6Origin fromVapiOrigin(Ipv6Types.IPv6AddressOrigin iPv6AddressOrigin) {
        switch (iPv6AddressOrigin.getEnumValue()) {
            case dhcp: {
                return IPv6Address.Ipv6Origin.DHCP;
            }
            case linklayer: {
                return IPv6Address.Ipv6Origin.LINKLAYER;
            }
            case manual: {
                return IPv6Address.Ipv6Origin.MANUAL;
            }
            case other: {
                return IPv6Address.Ipv6Origin.OTHER;
            }
            case random: {
                return IPv6Address.Ipv6Origin.RANDOM;
            }
        }
        throw new IllegalStateException();
    }

    static FirewallAddressRule[] fromVapiFirewallRuleList(List<InboundTypes.FirewallAddressRule> list) {
        if (list == null) {
            return null;
        }
        FirewallAddressRule[] firewallAddressRuleArray = new FirewallAddressRule[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            FirewallAddressRule firewallAddressRule;
            firewallAddressRuleArray[i] = firewallAddressRule = VapiToXmlRpcConverter.fromVapiStruct(list.get(i), i);
        }
        return firewallAddressRuleArray;
    }

    static List<InboundTypes.FirewallAddressRule> toVapiFirewallRuleList(FirewallAddressRule[] firewallAddressRuleArray) {
        ArrayList<InboundTypes.FirewallAddressRule> arrayList = new ArrayList<InboundTypes.FirewallAddressRule>();
        if (firewallAddressRuleArray != null) {
            for (FirewallAddressRule firewallAddressRule : firewallAddressRuleArray) {
                arrayList.add(VapiToXmlRpcConverter.toVapiStruct(firewallAddressRule));
            }
        }
        return arrayList;
    }

    static InboundTypes.FirewallAddressRule toVapiStruct(FirewallAddressRule firewallAddressRule) {
        InboundTypes.FirewallAddressRule firewallAddressRule2 = new InboundTypes.FirewallAddressRule();
        firewallAddressRule2.setAddress(firewallAddressRule.address);
        firewallAddressRule2.setInterfaceName(firewallAddressRule.nic);
        firewallAddressRule2.setPolicy(firewallAddressRule.policy == FirewallAddressRule.FirewallRulePolicy.ALLOW ? InboundTypes.FirewallRulePolicy.allow : InboundTypes.FirewallRulePolicy.deny);
        firewallAddressRule2.setPrefix((long)firewallAddressRule.prefix);
        return firewallAddressRule2;
    }

    static FirewallAddressRule fromVapiStruct(InboundTypes.FirewallAddressRule firewallAddressRule, int n) {
        FirewallAddressRule firewallAddressRule2 = new FirewallAddressRule();
        firewallAddressRule2.order = n;
        firewallAddressRule2.policy = firewallAddressRule.getPolicy() == InboundTypes.FirewallRulePolicy.allow ? FirewallAddressRule.FirewallRulePolicy.ALLOW : FirewallAddressRule.FirewallRulePolicy.DENY;
        firewallAddressRule2.address = firewallAddressRule.getAddress();
        firewallAddressRule2.nic = firewallAddressRule.getInterfaceName();
        firewallAddressRule2.prefix = (int)firewallAddressRule.getPrefix();
        return firewallAddressRule2;
    }

    static NetworkRoute[] fromVapiRouteList(List<RoutesTypes.RouteReadOnly> list) {
        if (list == null) {
            return null;
        }
        NetworkRoute[] networkRouteArray = new NetworkRoute[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            NetworkRoute networkRoute = new NetworkRoute();
            networkRoute.prefix = (int)list.get(i).getPrefix();
            networkRoute.nic = list.get(i).getInterfaceName();
            networkRoute.destination = list.get(i).getDestination();
            networkRoute.gateway = list.get(i).getGateway();
            networkRouteArray[i] = networkRoute;
        }
        return networkRouteArray;
    }

    static List<RoutesTypes.Route> toVapiRouteList(NetworkRoute[] networkRouteArray) {
        ArrayList<RoutesTypes.Route> arrayList = new ArrayList<RoutesTypes.Route>();
        if (networkRouteArray != null) {
            for (NetworkRoute networkRoute : networkRouteArray) {
                RoutesTypes.Route route = new RoutesTypes.Route();
                route.setGateway(networkRoute.gateway);
                route.setDestination(networkRoute.destination);
                route.setInterfaceName(networkRoute.nic);
                route.setPrefix((long)networkRoute.prefix);
                arrayList.add(route);
            }
        }
        return arrayList;
    }

    static ShutdownTypes.ShutdownConfig toVapiStruct(PowerOperationConfig powerOperationConfig) {
        ShutdownTypes.ShutdownConfig shutdownConfig = new ShutdownTypes.ShutdownConfig();
        shutdownConfig.setDelay((long)powerOperationConfig.delay);
        shutdownConfig.setReason(powerOperationConfig.reason);
        return shutdownConfig;
    }
}

