/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.data.query.type;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cm.UserSpecificCmFactory;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceProvider;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmSsoServiceProviderImpl
implements SsoServiceProvider,
UserSessionListener {
    private static final Log _logger = LogFactory.getLog(CmSsoServiceProviderImpl.class);
    private static final String CM_SSO_SERVICE_CACHE_KEY = "cmSsoServiceCache";
    private UserSpecificCmFactory _cmFactory = null;
    private SsoService _ssoService = null;

    public CmSsoServiceProviderImpl() {
        _logger.info((Object)"instantiated");
    }

    public void setUserSpecificCmFactory(UserSpecificCmFactory userSpecificCmFactory) {
        this._cmFactory = userSpecificCmFactory;
    }

    public void setSsoService(SsoService ssoService) {
        this._ssoService = ssoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        Map map = (Map)SessionUtil.removeData((String)CM_SSO_SERVICE_CACHE_KEY, (HttpSession)httpSessionEvent.getSession());
        if (map == null || map.isEmpty()) {
            return;
        }
        CmSsoServiceProviderImpl cmSsoServiceProviderImpl = this;
        synchronized (cmSsoServiceProviderImpl) {
            for (String string : map.keySet()) {
                SsoAdminService ssoAdminService = (SsoAdminService)map.get(string);
                try {
                    ssoAdminService.logout();
                }
                catch (Exception exception) {
                    _logger.error((Object)("Failed to log out of service " + ssoAdminService), (Throwable)exception);
                }
            }
        }
        map.clear();
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    @type(value="cm:Server")
    public SsoAdminService getAdminService(URI uRI) throws Exception {
        SsoAdminService ssoAdminService;
        String string = CmReferenceUtil.getServerId(uRI);
        Map map = (Map)SessionUtil.getData((String)CM_SSO_SERVICE_CACHE_KEY);
        if (map != null && (ssoAdminService = (SsoAdminService)map.get(string)) != null) {
            return ssoAdminService;
        }
        return this.getAdminServiceSynchronized(uRI);
    }

    private synchronized SsoAdminService getAdminServiceSynchronized(URI uRI) throws Exception {
        Object object;
        String string = CmReferenceUtil.getServerId(uRI);
        Object object2 = SessionUtil.getData((String)CM_SSO_SERVICE_CACHE_KEY);
        if (object2 != null && (object = (SsoAdminService)object2.get(string)) != null) {
            return object;
        }
        if (object2 == null && (object = (HashMap)SessionUtil.setDataIfAbsent((String)CM_SSO_SERVICE_CACHE_KEY, object2 = new HashMap())) != null) {
            object2 = object;
        }
        if ((object = this.findSsoServiceInfo(uRI)) == null) {
            throw CmUtil.getFault("error.ssoServiceInfoNotFound", uRI.toString());
        }
        SsoServerInfo ssoServerInfo = this.createServerInfo((ServiceInfo)object);
        SsoAdminService ssoAdminService = SsoUtil.getAdminService((SsoServerInfo)ssoServerInfo, (SsoService)this._ssoService, (SamlToken)AuthSessionUtil.getSsoToken());
        object2.put(string, ssoAdminService);
        return ssoAdminService;
    }

    private ServiceInfo findSsoServiceInfo(URI uRI) throws ComponentManagerFault {
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        ServiceEndPointTypeImpl serviceEndPointTypeImpl = new ServiceEndPointTypeImpl();
        serviceEndPointTypeImpl.setTypeId("com.vmware.cis.cs.identity.admin");
        searchCriteriaImpl.setEndPointType((ServiceEndPointType)serviceEndPointTypeImpl);
        Object[] objectArray = this._cmFactory.getComponentManagerService().search((SearchCriteria)searchCriteriaImpl);
        String string = CmReferenceUtil.getServerId(uRI);
        if (string == null) {
            return null;
        }
        for (ServiceInfo serviceInfo : (ServiceInfo[])ArrayUtil.toSafe((Object[])objectArray, ServiceInfo.class)) {
            String string2 = CmUtil.getServerHostname(serviceInfo);
            if (!string.equals(string2)) continue;
            return serviceInfo;
        }
        return null;
    }

    private SsoServerInfo createServerInfo(ServiceInfo serviceInfo) throws Exception {
        ServiceEndPoint[] serviceEndPointArray;
        for (ServiceEndPoint serviceEndPoint : serviceEndPointArray = serviceInfo.getServiceEndPoints()) {
            if (!serviceEndPoint.getEndPointType().getTypeId().equals("com.vmware.cis.cs.identity.admin")) continue;
            SsoServerInfo.Builder builder = new SsoServerInfo.Builder();
            builder.adminAppUrl = serviceEndPoint.getUrl().toString();
            builder.keyStore = this._ssoService.getServerInfo().getKeyStore();
            return builder.getInstance();
        }
        return null;
    }
}

