/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vapi.bindings.client.RetryPolicy;
import com.vmware.vapi.client.exception.TransportProtocolException;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.std.errors.Unauthenticated;
import com.vmware.vise.vim.vapi.VapiConnectionControl;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.NodeInaccessibleHaltException;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import java.net.SocketTimeoutException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ConnectTimeoutException;

public class CmVapiConnectionControlFactory
implements VapiConnectionManagerRegistry.ControlFactory<String> {
    private static final Log _logger = LogFactory.getLog(CmVapiConnectionControlFactory.class);
    private final PropertyCache<String> _unreachableServersCache;
    private final ConcurrentMap<String, AtomicInteger> _requestsPerNode;
    private final int _maxRequestsPerNode;
    private final Object _sentinelValue = new Object();

    public CmVapiConnectionControlFactory(PropertyCache<String> propertyCache, int n) {
        Validate.notNull(propertyCache);
        Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"Max requests per node should be positive");
        this._unreachableServersCache = propertyCache;
        this._requestsPerNode = new ConcurrentHashMap<String, AtomicInteger>();
        this._maxRequestsPerNode = n;
    }

    public VapiConnectionControl getControlForEndpoint(String string) {
        return new SingleNodeThrottlingConnectionControl(string);
    }

    private AtomicInteger getRequestCountForNode(String string) {
        if (!this._requestsPerNode.containsKey(string)) {
            this._requestsPerNode.putIfAbsent(string, new AtomicInteger(0));
        }
        return (AtomicInteger)this._requestsPerNode.get(string);
    }

    private class RequestCountingAsyncHandle
    extends AsyncHandle<MethodResult> {
        private final AsyncHandle<MethodResult> _originalHandle;
        private final String _serverName;

        private RequestCountingAsyncHandle(AsyncHandle<MethodResult> asyncHandle, String string) {
            this._originalHandle = asyncHandle;
            this._serverName = string;
        }

        public void updateProgress(DataValue dataValue) {
            this._originalHandle.updateProgress(dataValue);
        }

        public void setResult(MethodResult methodResult) {
            int n = CmVapiConnectionControlFactory.this.getRequestCountForNode(this._serverName).decrementAndGet();
            this._originalHandle.setResult((Object)methodResult);
        }

        public void setError(RuntimeException runtimeException) {
            int n = CmVapiConnectionControlFactory.this.getRequestCountForNode(this._serverName).decrementAndGet();
            this._originalHandle.setError(runtimeException);
        }
    }

    private class ThrottlingApiProvider
    implements ApiProvider {
        private final ApiProvider _nestedProvider;
        private final String _serverName;

        private ThrottlingApiProvider(ApiProvider apiProvider, String string) {
            this._nestedProvider = apiProvider;
            this._serverName = string;
        }

        public void invoke(String string, String string2, DataValue dataValue, ExecutionContext executionContext, AsyncHandle<MethodResult> asyncHandle) {
            int n;
            if (CmVapiConnectionControlFactory.this._unreachableServersCache.getProperty(this._serverName, "__singleton") != null) {
                asyncHandle.setError((RuntimeException)new NodeInaccessibleHaltException(this._serverName));
            }
            if ((n = CmVapiConnectionControlFactory.this.getRequestCountForNode(this._serverName).incrementAndGet()) <= CmVapiConnectionControlFactory.this._maxRequestsPerNode) {
                this._nestedProvider.invoke(string, string2, dataValue, executionContext, (AsyncHandle)new RequestCountingAsyncHandle(asyncHandle, this._serverName));
            } else {
                n = CmVapiConnectionControlFactory.this.getRequestCountForNode(this._serverName).decrementAndGet();
                asyncHandle.setError(new RuntimeException("Too many requests for node."));
            }
        }
    }

    private class SingleNodeThrottlingConnectionControl
    implements VapiConnectionControl {
        private static final int MAX_REAUTHENTICATION_ATTEMPTS = 1;
        private final String _serverName;

        private SingleNodeThrottlingConnectionControl(String string) {
            this._serverName = string;
        }

        public boolean retryOnError(RuntimeException runtimeException, RetryPolicy.RetryContext retryContext, int n) {
            Throwable throwable;
            if (runtimeException instanceof Unauthenticated) {
                return n < 1;
            }
            if (runtimeException instanceof TransportProtocolException && ((throwable = runtimeException.getCause()) instanceof SocketTimeoutException || throwable instanceof ConnectTimeoutException) && CmVapiConnectionControlFactory.this._unreachableServersCache.getProperty(this._serverName, "__singleton") == null) {
                _logger.warn((Object)"Received timeout exception, will throttle subsequent calls", throwable);
                CmVapiConnectionControlFactory.this._unreachableServersCache.setProperty(this._serverName, "__singleton", CmVapiConnectionControlFactory.this._sentinelValue);
            }
            return false;
        }

        public ApiProvider getApiProvider(ApiProvider apiProvider) {
            return new ThrottlingApiProvider(apiProvider, this._serverName);
        }
    }
}

