/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.appliance.vmon.Service;
import com.vmware.appliance.vmon.ServiceTypes;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vapi.std.errors.InvalidElementConfiguration;
import com.vmware.vapi.std.errors.NotAllowedInCurrentState;
import com.vmware.vapi.std.errors.NotFound;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.ServiceOperationSpec;
import com.vmware.vsphere.client.cm.ServiceStartupTypeSpec;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmonServiceControlProvider {
    private static final Log _logger = LogFactory.getLog(VmonServiceControlProvider.class);
    private final VapiConnectionManagerRegistry<String> _vmonConnectionRegistry;

    public VmonServiceControlProvider(VapiConnectionManagerRegistry<String> vapiConnectionManagerRegistry) {
        this._vmonConnectionRegistry = vapiConnectionManagerRegistry;
    }

    public OperationResult apply(URI uRI, ServiceOperationSpec serviceOperationSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        String string = CmReferenceUtil.getId(uRI);
        try {
            Service service = (Service)this._vmonConnectionRegistry.getService(Service.class, (Object)CmReferenceUtil.getServerId(uRI));
            switch (serviceOperationSpec.operation) {
                case START: {
                    service.start(string);
                    break;
                }
                case STOP: {
                    service.stop(string);
                    break;
                }
                case RESTART: {
                    service.restart(string);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown runtime state: " + (Object)((Object)serviceOperationSpec.operation));
                }
            }
        }
        catch (NotAllowedInCurrentState | NotFound throwable) {
            operationResult.error = throwable;
        }
        return operationResult;
    }

    public OperationResult apply(URI uRI, ServiceStartupTypeSpec serviceStartupTypeSpec) {
        ServiceTypes.StartupType startupType;
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        ServiceTypes.UpdateSpec updateSpec = new ServiceTypes.UpdateSpec();
        switch (serviceStartupTypeSpec.type) {
            case AUTOMATIC: {
                startupType = ServiceTypes.StartupType.AUTOMATIC;
                break;
            }
            case MANUAL: {
                startupType = ServiceTypes.StartupType.MANUAL;
                break;
            }
            case DISABLED: {
                startupType = ServiceTypes.StartupType.DISABLED;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized startup type: " + serviceStartupTypeSpec.type.toString());
            }
        }
        updateSpec.setStartupType(startupType);
        Service service = (Service)this._vmonConnectionRegistry.getService(Service.class, (Object)CmReferenceUtil.getServerId(uRI));
        String string = CmReferenceUtil.getId(uRI);
        try {
            service.update(string, updateSpec);
        }
        catch (InvalidArgument | InvalidElementConfiguration | NotAllowedInCurrentState | NotFound throwable) {
            operationResult.error = throwable;
        }
        return operationResult;
    }
}

