/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class CachingPropertyValueExtractor<T> {
    private static final Log _logger = LogFactory.getLog(CachingPropertyValueExtractor.class);
    private final PropertyCache<T> _cache;
    private final Set<String> _cacheableProperties;
    private final Executor _executor;

    public CachingPropertyValueExtractor(PropertyCache<T> propertyCache, Set<String> set, Executor executor) {
        this._cache = propertyCache;
        this._cacheableProperties = set;
        this._executor = executor;
    }

    protected Object[] getValuesPerProperty(T[] TArray, String string) {
        if (this._cacheableProperties.contains(string)) {
            return this.getValuesPerPropertyCached(TArray, string);
        }
        return this.retrieveValuesPerProperty(TArray, string);
    }

    protected Object[] getValuesPerPropertyCached(T[] TArray, String string) {
        assert (this._cacheableProperties.contains(string));
        Object c = this._cache.getProperty(TArray, string);
        if (c != null) {
            return c;
        }
        Object[] objectArray = this.retrieveValuesPerProperty(TArray, string);
        this._cache.setProperty(TArray, string, objectArray);
        return objectArray;
    }

    private Object[] retrieveValuesPerProperty(T[] TArray, String string) {
        Object[] objectArray;
        if (this.propertyNeedsRemoteCall(string)) {
            List list;
            Map<String, List<ObjectPositionPair<T>>> map = this.mapObjectsByServer(TArray);
            String[] stringArray = map.keySet().toArray(new String[map.keySet().size()]);
            objectArray = new Object[TArray.length];
            ArrayList<PerServerTask> arrayList = new ArrayList<PerServerTask>();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(new PerServerTask(map.get(stringArray[i]), string));
            }
            try {
                list = ExecutorUtil.executeTasks(arrayList, (Executor)this._executor);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                List<ObjectPositionPair<T>> list2 = map.get(stringArray[i]);
                ExecutorUtil.TaskResult taskResult = (ExecutorUtil.TaskResult)list.get(i);
                Exception exception = taskResult.getException();
                if (exception != null) {
                    _logger.warn((Object)("Could not retrieve properties for node " + stringArray[i]), (Throwable)exception);
                    continue;
                }
                Object[] objectArray2 = (Object[])taskResult.getResult();
                for (int j = 0; j < list2.size(); ++j) {
                    ObjectPositionPair<T> objectPositionPair = list2.get(j);
                    objectArray[objectPositionPair.position] = objectArray2[j];
                }
            }
        } else {
            objectArray = this.getValuesPerPropertyDirectly(TArray, string, false);
        }
        this.sanitizeValues(string, objectArray);
        return objectArray;
    }

    protected abstract Object[] getValuesPerPropertyDirectly(T[] var1, String var2, boolean var3);

    protected void sanitizeValues(String string, Object[] objectArray) {
    }

    protected boolean propertyNeedsRemoteCall(String string) {
        return true;
    }

    protected abstract String getServerId(T var1);

    private Map<String, List<ObjectPositionPair<T>>> mapObjectsByServer(T[] TArray) {
        HashMap<String, List<ObjectPositionPair<T>>> hashMap = new HashMap<String, List<ObjectPositionPair<T>>>();
        for (int i = 0; i < TArray.length; ++i) {
            List<Object> list;
            ObjectPositionPair objectPositionPair = new ObjectPositionPair();
            objectPositionPair.position = i;
            objectPositionPair.obj = TArray[i];
            String string = this.getServerId(TArray[i]);
            if (hashMap.containsKey(string)) {
                list = hashMap.get(string);
                list.add(objectPositionPair);
                continue;
            }
            list = new ArrayList();
            ((ArrayList)list).add(objectPositionPair);
            hashMap.put(string, list);
        }
        return hashMap;
    }

    private class PerServerTask
    implements Callable<Object[]> {
        private final T[] _objects;
        private final String _propertyName;

        public PerServerTask(List<ObjectPositionPair<T>> list, String string) {
            assert (list.size() > 0);
            Object t = list.get((int)0).obj;
            Object[] objectArray = (Object[])Array.newInstance(t.getClass(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                objectArray[i] = list.get((int)i).obj;
            }
            this._objects = objectArray;
            this._propertyName = string;
        }

        @Override
        public Object[] call() throws Exception {
            return CachingPropertyValueExtractor.this.getValuesPerPropertyDirectly(this._objects, this._propertyName, true);
        }
    }

    private static class ObjectPositionPair<T> {
        int position;
        T obj;

        private ObjectPositionPair() {
        }
    }
}

