/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vapi.std.errors.InternalServerError;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.VmInfo;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUiFeatureSwitch;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.DataRetrieverResult;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import com.vmware.vsphere.client.cm.util.ServerPropertyValueExtractor;
import com.vmware.vsphere.client.cm.util.ServiceInfoPropertyValueExtractor;
import com.vmware.vsphere.client.cm.util.SessionBackedPropertyCache;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataRetriever {
    private static final Log _logger = LogFactory.getLog(DataRetriever.class);
    private static final String ALL_SERVERS_CACHE_KEY = "__allServers";
    private static final String SERVICE_IDENTITY_KEY = "serviceIdentity";
    private static final String SERVER_IDENTITY_KEY = "serverIdentity";
    private final ScaServiceManager _scaServiceManager;
    private SsoServiceManager _ssoServiceManager;
    private final ServerPropertyValueExtractor _serverValueExtractor;
    private final ServiceInfoPropertyValueExtractor _serviceValueExtractor;
    private final Executor _executor;
    private final ObjectReferenceService _objectReferenceService;
    private final PropertyCache<InternalServerInfo> _serverPropertyCache;
    private final VapiConnectionManagerRegistry<String> _vmonConnectionRegistry;
    private final CmUiFeatureSwitch _killSwitch;
    private PropertyCache<String> _identityCache = new SessionBackedPropertyCache<String>("cmIdentityCache");

    public DataRetriever(ScaServiceManager scaServiceManager, VapiConnectionManagerRegistry<String> vapiConnectionManagerRegistry, CmUiFeatureSwitch cmUiFeatureSwitch, ServerPropertyValueExtractor serverPropertyValueExtractor, ServiceInfoPropertyValueExtractor serviceInfoPropertyValueExtractor, PropertyCache<InternalServerInfo> propertyCache, Executor executor, ObjectReferenceService objectReferenceService) {
        this._scaServiceManager = scaServiceManager;
        this._vmonConnectionRegistry = vapiConnectionManagerRegistry;
        this._killSwitch = cmUiFeatureSwitch;
        this._serverValueExtractor = serverPropertyValueExtractor;
        this._serviceValueExtractor = serviceInfoPropertyValueExtractor;
        this._serverPropertyCache = propertyCache;
        this._executor = executor;
        this._objectReferenceService = objectReferenceService;
    }

    public void setSsoServiceManager(SsoServiceManager ssoServiceManager) {
        this._ssoServiceManager = ssoServiceManager;
    }

    public ServiceInfoPropertyValueExtractor getServiceValueExtractor() {
        return this._serviceValueExtractor;
    }

    public ServerPropertyValueExtractor getServerValueExtractor() {
        return this._serverValueExtractor;
    }

    public ObjectReferenceService getObjectReferenceService() {
        return this._objectReferenceService;
    }

    public DataRetrieverResult<InternalServiceInfo> retrieveServices(Constraint constraint) {
        DataRetrieverResult<InternalServiceInfo> dataRetrieverResult;
        if (!DataRetriever.isServiceConstraint(constraint)) {
            return DataRetrieverResult.EMPTY_SERVICE_RESULT;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            DataRetrieverResult[] dataRetrieverResultArray = new DataRetrieverResult[compositeConstraint.nestedConstraints.length];
            for (int i = 0; i < compositeConstraint.nestedConstraints.length; ++i) {
                dataRetrieverResultArray[i] = this.retrieveServices(compositeConstraint.nestedConstraints[i]);
            }
            dataRetrieverResult = DataRetrieverResult.applySetOperation(compositeConstraint.conjoiner, dataRetrieverResultArray);
        } else if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            dataRetrieverResult = this.retrieveServicesByRelation(relationalConstraint);
        } else if (constraint instanceof PropertyConstraint) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            DataRetrieverResult<InternalServiceInfo> dataRetrieverResult2 = this.retrieveServicesInternal();
            Collection<InternalServiceInfo> collection = this.filterServicesByProperty(dataRetrieverResult2.getResultCollection(), propertyConstraint);
            dataRetrieverResult = new DataRetrieverResult<InternalServiceInfo>(collection, dataRetrieverResult2.getException(), InternalServiceInfo.class);
        } else if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            if (CmReferenceUtil.isReferenceOfType(objectIdentityConstraint.target, "cm:Service", this._objectReferenceService)) {
                URI uRI = (URI)objectIdentityConstraint.target;
                String string = CmReferenceUtil.getId(uRI);
                String string2 = CmReferenceUtil.getServerId(uRI);
                ServiceRetrieval serviceRetrieval = new ServiceRetrieval(string2, new String[]{string});
                dataRetrieverResult = serviceRetrieval.getCachedResult();
                if (dataRetrieverResult == null) {
                    dataRetrieverResult = serviceRetrieval.retrieveResult();
                    serviceRetrieval.cacheRetrievedResult();
                }
            } else {
                dataRetrieverResult = DataRetrieverResult.EMPTY_SERVICE_RESULT;
            }
        } else {
            dataRetrieverResult = this.retrieveServicesInternal();
        }
        return dataRetrieverResult;
    }

    public DataRetrieverResult<InternalServerInfo> retrieveServers(Constraint constraint) {
        DataRetrieverResult<InternalServerInfo> dataRetrieverResult;
        if (!DataRetriever.isServerConstraint(constraint)) {
            return DataRetrieverResult.EMPTY_SERVER_RESULT;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            DataRetrieverResult[] dataRetrieverResultArray = new DataRetrieverResult[compositeConstraint.nestedConstraints.length];
            for (int i = 0; i < compositeConstraint.nestedConstraints.length; ++i) {
                dataRetrieverResultArray[i] = this.retrieveServers(compositeConstraint.nestedConstraints[i]);
            }
            dataRetrieverResult = DataRetrieverResult.applySetOperation(compositeConstraint.conjoiner, dataRetrieverResultArray);
        } else if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            Collection<InternalServerInfo> collection = this.retrieveServersByRelation(relationalConstraint);
            dataRetrieverResult = new DataRetrieverResult<InternalServerInfo>(collection, null, InternalServerInfo.class);
        } else if (constraint instanceof PropertyConstraint) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            Collection<InternalServerInfo> collection = this.retrieveServersInternal();
            Collection<InternalServerInfo> collection2 = this.filterServersByProperty(collection, propertyConstraint);
            dataRetrieverResult = new DataRetrieverResult<InternalServerInfo>(collection2, null, InternalServerInfo.class);
        } else if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            dataRetrieverResult = DataRetrieverResult.EMPTY_SERVER_RESULT;
            if (CmReferenceUtil.isReferenceOfType(objectIdentityConstraint.target, "cm:Server", this._objectReferenceService)) {
                URI uRI = (URI)objectIdentityConstraint.target;
                String string = CmReferenceUtil.getServerId(uRI);
                Collection<InternalServerInfo> collection = this.retrieveServersInternal();
                for (InternalServerInfo internalServerInfo : collection) {
                    String string2 = internalServerInfo.getHostname();
                    if (!string.equals(string2)) continue;
                    dataRetrieverResult = new DataRetrieverResult<InternalServerInfo>(Collections.singleton(internalServerInfo), null, InternalServerInfo.class);
                    break;
                }
            }
        } else {
            dataRetrieverResult = new DataRetrieverResult<InternalServerInfo>(this.retrieveServersInternal(), null, InternalServerInfo.class);
        }
        return dataRetrieverResult;
    }

    private DataRetrieverResult<InternalServiceInfo> retrieveServicesByRelation(RelationalConstraint relationalConstraint) {
        DataRetrieverResult<InternalServiceInfo> dataRetrieverResult = DataRetrieverResult.EMPTY_SERVICE_RESULT;
        if ("services".equals(relationalConstraint.relation)) {
            DataRetrieverResult<InternalServerInfo> dataRetrieverResult2 = this.retrieveServers(relationalConstraint.constraintOnRelatedObject);
            dataRetrieverResult = this.retrieveServicesFromServers(dataRetrieverResult2.getResultCollection());
        }
        return dataRetrieverResult;
    }

    private DataRetrieverResult<InternalServiceInfo> retrieveServicesInternal() {
        Collection<InternalServerInfo> collection = this.retrieveServersInternal();
        return this.retrieveServicesFromServers(collection);
    }

    private DataRetrieverResult<InternalServiceInfo> retrieveServicesFromServers(Collection<InternalServerInfo> collection) {
        ExecutorUtil.TaskResult taskResult;
        if (CollectionUtil.isNullOrEmpty(collection)) {
            return DataRetrieverResult.EMPTY_SERVICE_RESULT;
        }
        DataRetrieverResult[] dataRetrieverResultArray = new DataRetrieverResult[collection.size()];
        ArrayList<ServiceRetrieval> arrayList = new ArrayList<ServiceRetrieval>();
        int n = 0;
        for (InternalServerInfo object : collection) {
            final ServiceRetrieval serviceRetrieval = new ServiceRetrieval(object);
            taskResult = serviceRetrieval.getCachedResult();
            if (taskResult != null) {
                dataRetrieverResultArray[n] = taskResult;
            } else {
                dataRetrieverResultArray[n] = null;
                arrayList.add(serviceRetrieval);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            ArrayList arrayList2 = new ArrayList();
            for (final ServiceRetrieval serviceRetrieval : arrayList) {
                arrayList2.add(new Callable<DataRetrieverResult<InternalServiceInfo>>(){

                    @Override
                    public DataRetrieverResult<InternalServiceInfo> call() throws Exception {
                        return serviceRetrieval.retrieveResult();
                    }
                });
            }
            try {
                List list = ExecutorUtil.executeTasks((List)arrayList2, (Executor)this._executor);
                int n2 = 0;
                for (n = 0; n < dataRetrieverResultArray.length; ++n) {
                    Exception exception;
                    if (dataRetrieverResultArray[n] != null) continue;
                    dataRetrieverResultArray[n] = (exception = (taskResult = (ExecutorUtil.TaskResult)list.get(n2++)).getException()) != null ? new DataRetrieverResult(Collections.emptyList(), exception, InternalServiceInfo.class) : (DataRetrieverResult)taskResult.getResult();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        for (ServiceRetrieval serviceRetrieval : arrayList) {
            serviceRetrieval.cacheRetrievedResult();
        }
        return DataRetrieverResult.applySetOperation(Conjoiner.OR, dataRetrieverResultArray);
    }

    private Collection<InternalServiceInfo> filterServicesByProperty(Collection<InternalServiceInfo> collection, PropertyConstraint propertyConstraint) {
        InternalServiceInfo[] internalServiceInfoArray = collection.toArray(new InternalServiceInfo[collection.size()]);
        Object[] objectArray = this._serviceValueExtractor.getValues(internalServiceInfoArray, new String[]{propertyConstraint.propertyName})[0];
        ArrayList<InternalServiceInfo> arrayList = new ArrayList<InternalServiceInfo>();
        for (int i = 0; i < internalServiceInfoArray.length; ++i) {
            if (!this.matchInternal(propertyConstraint, objectArray[i])) continue;
            arrayList.add(internalServiceInfoArray[i]);
        }
        return arrayList;
    }

    private Collection<InternalServerInfo> retrieveServersByRelation(RelationalConstraint relationalConstraint) {
        ArrayList<InternalServerInfo> arrayList = new ArrayList<InternalServerInfo>();
        if ("server".equals(relationalConstraint.relation)) {
            Collection<InternalServerInfo> collection = this.retrieveServersInternal();
            DataRetrieverResult<InternalServiceInfo> dataRetrieverResult = this.retrieveServices(relationalConstraint.constraintOnRelatedObject);
            HashSet<String> hashSet = new HashSet<String>();
            for (InternalServiceInfo internalServiceInfo : dataRetrieverResult.getResult()) {
                hashSet.add(internalServiceInfo.getServerHostname());
            }
            for (InternalServerInfo internalServerInfo : collection) {
                if (!hashSet.contains(internalServerInfo.getHostname())) continue;
                arrayList.add(internalServerInfo);
            }
        }
        return arrayList;
    }

    private Collection<InternalServerInfo> retrieveServersInternal() {
        Collection collection = (Collection)this._identityCache.getProperty(ALL_SERVERS_CACHE_KEY, SERVER_IDENTITY_KEY);
        if (collection != null) {
            return collection;
        }
        Collection<InternalServerInfo> collection2 = CmUtil.getServers(this._ssoServiceManager);
        this._identityCache.setProperty(ALL_SERVERS_CACHE_KEY, SERVER_IDENTITY_KEY, collection2);
        return collection2;
    }

    private Collection<InternalServerInfo> filterServersByProperty(Collection<InternalServerInfo> collection, PropertyConstraint propertyConstraint) {
        InternalServerInfo[] internalServerInfoArray = collection.toArray(new InternalServerInfo[collection.size()]);
        Object[] objectArray = this._serverValueExtractor.getValues(internalServerInfoArray, new String[]{propertyConstraint.propertyName})[0];
        ArrayList<InternalServerInfo> arrayList = new ArrayList<InternalServerInfo>();
        for (int i = 0; i < internalServerInfoArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof VmInfo) {
                object = ((VmInfo)((Object)object)).name;
            }
            if (!this.matchInternal(propertyConstraint, object)) continue;
            arrayList.add(internalServerInfoArray[i]);
        }
        return arrayList;
    }

    private boolean matchInternal(PropertyConstraint propertyConstraint, Object object) {
        if (object == null && propertyConstraint.comparableValue == null) {
            return true;
        }
        if (object == null || propertyConstraint.comparableValue == null) {
            return false;
        }
        String string = object.toString().toLowerCase();
        String string2 = propertyConstraint.comparableValue.toString().toLowerCase();
        switch (propertyConstraint.comparator) {
            case EQUALS: {
                return string.equals(string2);
            }
            case NOT_EQUALS: {
                return !string.equals(string2);
            }
            case TEXTUALLY_MATCHES: 
            case CONTAINS: {
                return string.contains(string2);
            }
            case ENDS_WITH: {
                return string.endsWith(string2);
            }
            case STARTS_WITH: {
                return string.startsWith(string2);
            }
        }
        _logger.debug((Object)("Unsupported comparator type used: " + propertyConstraint.comparator));
        return false;
    }

    public Object[][] getServerValues(InternalServerInfo[] internalServerInfoArray, String[] stringArray) {
        return this._serverValueExtractor.getValues(internalServerInfoArray, stringArray);
    }

    public Object[][] getServiceValues(InternalServiceInfo[] internalServiceInfoArray, String[] stringArray) {
        return this._serviceValueExtractor.getValues(internalServiceInfoArray, stringArray);
    }

    private static boolean isServiceConstraint(Constraint constraint) {
        return constraint.targetType == null || constraint.targetType.equalsIgnoreCase("cm:Service");
    }

    private static boolean isServerConstraint(Constraint constraint) {
        return constraint.targetType == null || constraint.targetType.equalsIgnoreCase("cm:Server");
    }

    private static String getServiceCacheId(String string, String string2) {
        return string + "/" + string2;
    }

    private class ServiceRetrieval {
        private InternalServerInfo _server;
        private final String _serverHostname;
        private final String[] _serviceIds;
        private Exception _exception = null;
        private Collection<InternalServiceInfo> _result = null;

        public ServiceRetrieval(InternalServerInfo internalServerInfo) {
            this(internalServerInfo, null);
        }

        public ServiceRetrieval(InternalServerInfo internalServerInfo, String[] stringArray) {
            this(internalServerInfo.getHostname(), stringArray);
            this._server = internalServerInfo;
        }

        public ServiceRetrieval(String string, String[] stringArray) {
            assert (string != null);
            this._serverHostname = string;
            this._serviceIds = stringArray;
        }

        DataRetrieverResult<InternalServiceInfo> retrieveResult() {
            this.retrieveResultInternal();
            return new DataRetrieverResult<InternalServiceInfo>(this._result, this._exception, InternalServiceInfo.class);
        }

        DataRetrieverResult<InternalServiceInfo> getCachedResult() {
            ArrayList<InternalServiceInfo> arrayList;
            if (this._serviceIds == null) {
                ArrayList<InternalServiceInfo> arrayList2 = null;
                if (this._server != null) {
                    arrayList2 = (ArrayList<InternalServiceInfo>)DataRetriever.this._serverPropertyCache.getProperty(this._server, "serviceInfos");
                }
                if (arrayList2 == null) {
                    return null;
                }
                arrayList = arrayList2;
            } else {
                String[] stringArray = new String[this._serviceIds.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = DataRetriever.getServiceCacheId(this._serviceIds[i], this._serverHostname);
                }
                Object c = DataRetriever.this._identityCache.getProperty(stringArray, DataRetriever.SERVICE_IDENTITY_KEY);
                if (c == null) {
                    return null;
                }
                arrayList = new ArrayList<InternalServiceInfo>();
                for (int i = 0; i < ((C)c).length; ++i) {
                    arrayList.add((InternalServiceInfo)c[i]);
                }
            }
            return new DataRetrieverResult<InternalServiceInfo>(arrayList, null, InternalServiceInfo.class);
        }

        void cacheRetrievedResult() {
            if (this._result == null || this._exception != null) {
                return;
            }
            if (this._server != null && this._serviceIds == null) {
                DataRetriever.this._serverPropertyCache.setProperty(this._server, "serviceInfos", this._result);
            }
            for (InternalServiceInfo internalServiceInfo : this._result) {
                DataRetriever.this._identityCache.setProperty(DataRetriever.getServiceCacheId(internalServiceInfo.getServiceId(), internalServiceInfo.getServerHostname()), DataRetriever.SERVICE_IDENTITY_KEY, internalServiceInfo);
            }
        }

        private void retrieveResultInternal() {
            assert (this._serverHostname != null);
            if (DataRetriever.this._killSwitch.useVmonForHost(this._serverHostname)) {
                try {
                    this._result = CmUtil.getVmonServicesForServer((VapiConnectionManagerRegistry<String>)DataRetriever.this._vmonConnectionRegistry, this._serverHostname, this._serviceIds);
                }
                catch (InternalServerError internalServerError) {
                    this._exception = DataException.newInstance((Throwable)internalServerError, (Object[])this._serviceIds, (String[])null);
                    this._result = Collections.emptyList();
                    _logger.error((Object)"Failed to retrieve services from vMon", (Throwable)internalServerError);
                }
            } else {
                try {
                    this._result = CmUtil.getScaServicesForServer(DataRetriever.this._scaServiceManager, this._serverHostname, this._serviceIds);
                }
                catch (ServiceManagerFault serviceManagerFault) {
                    this._exception = DataException.newInstance((Throwable)serviceManagerFault, (Object[])this._serviceIds, (String[])null);
                    this._result = Collections.emptyList();
                    _logger.error((Object)("Failed to retrieve services from SCA: " + serviceManagerFault.getErrorMessage()), (Throwable)serviceManagerFault);
                }
            }
        }
    }
}

