/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataRetrieverResult<T> {
    private Collection<T> _result;
    private Exception _exception;
    private Class<?> _resultType;
    private static final Collection<InternalServerInfo> EMPTY_SERVER_COLLECTION = Collections.emptyList();
    private static final Collection<InternalServiceInfo> EMPTY_SERVICE_COLLECTION = Collections.emptyList();
    private static final Log _logger = LogFactory.getLog(DataRetrieverResult.class);
    public static final DataRetrieverResult<InternalServiceInfo> EMPTY_SERVICE_RESULT = new DataRetrieverResult<InternalServiceInfo>(EMPTY_SERVICE_COLLECTION, null, InternalServiceInfo.class);
    public static final DataRetrieverResult<InternalServerInfo> EMPTY_SERVER_RESULT = new DataRetrieverResult<InternalServerInfo>(EMPTY_SERVER_COLLECTION, null, InternalServerInfo.class);

    public DataRetrieverResult(Collection<T> collection, Exception exception, Class<?> clazz) {
        this._result = collection;
        this._exception = exception;
        this._resultType = clazz;
    }

    public T[] getResult() {
        this.makeResultList();
        Object[] objectArray = (Object[])Array.newInstance(this._resultType, this._result.size());
        return this._result.toArray(objectArray);
    }

    public Exception getException() {
        return this._exception;
    }

    @SafeVarargs
    public static <T> DataRetrieverResult<T> applySetOperation(Conjoiner conjoiner, DataRetrieverResult<T> ... dataRetrieverResultArray) {
        int n;
        int n2 = dataRetrieverResultArray.length;
        assert (n2 > 0);
        Class<?> clazz = dataRetrieverResultArray[0]._resultType;
        Collection collection = dataRetrieverResultArray[0]._result;
        block5: for (int i = 1; i < n2; ++i) {
            Collection<T> collection2 = dataRetrieverResultArray[i]._result;
            switch (conjoiner) {
                case AND: {
                    collection = CollectionUtil.intersection(collection, collection2);
                    continue block5;
                }
                case OR: {
                    collection = CollectionUtil.union(collection, collection2);
                    continue block5;
                }
                case EXCEPT: {
                    collection = CollectionUtil.minus(collection, collection2);
                }
            }
        }
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        if (CollectionUtil.isNullOrEmpty(collection)) {
            for (n = 0; n < n2; ++n) {
                Exception exception = dataRetrieverResultArray[n]._exception;
                if (exception == null) continue;
                if (exception instanceof CompositeException) {
                    for (Exception exception2 : ((CompositeException)exception).getExceptions()) {
                        arrayList.add(exception2);
                    }
                    continue;
                }
                arrayList.add(exception);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                Exception exception = dataRetrieverResultArray[n]._exception;
                if (exception == null) continue;
                _logger.warn((Object)"Received partial result, igoring error", (Throwable)exception);
            }
        }
        Exception exception = arrayList.size() == 0 ? null : (arrayList.size() == 1 ? (Exception)arrayList.get(0) : new CompositeException(arrayList));
        return new DataRetrieverResult<T>(collection, exception, clazz);
    }

    public void sort(Comparator<T> comparator) {
        this.makeResultList();
        Collections.sort((List)this._result, comparator);
    }

    public DataRetrieverResult<T> slice(int n, int n2) {
        this.makeResultList();
        List list = (List)this._result;
        List list2 = list.subList(n, n2);
        return new DataRetrieverResult(list2, this._exception, this._resultType);
    }

    Collection<T> getResultCollection() {
        return this._result;
    }

    private void makeResultList() {
        if (!(this._result instanceof List)) {
            this._result = new ArrayList<T>(this._result);
        }
    }
}

