/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class PropertyCache<T> {
    public static final String SINGLETON_PROPERTY = "__singleton";
    private static final int DEFAULT_EXPIRATION_TIMEOUT_SECONDS = 2;
    private final int _expirationTimeoutSeconds;

    public PropertyCache() {
        this(2);
    }

    public PropertyCache(int n) {
        this._expirationTimeoutSeconds = n;
    }

    public Object[] getProperty(T[] TArray, String string) {
        HashMap<T, ExpirableData> hashMap = this.getMapForProperty(string);
        if (hashMap.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Object[TArray.length];
        for (int i = 0; i < TArray.length; ++i) {
            objectArray[i] = this.getPropertyFromMap(hashMap, TArray[i]);
            if (objectArray[i] != null) continue;
            return null;
        }
        return objectArray;
    }

    public <C> C getProperty(T t, String string) {
        HashMap<T, ExpirableData> hashMap = this.getMapForProperty(string);
        return this.getPropertyFromMap(hashMap, t);
    }

    public void clear() {
        this.getRootMap().clear();
    }

    public void setProperty(T[] TArray, String string, Object[] objectArray) {
        assert (TArray.length == objectArray.length);
        HashMap<T, ExpirableData> hashMap = this.getMapForProperty(string);
        for (int i = 0; i < TArray.length; ++i) {
            this.setPropertyOnMap(hashMap, TArray[i], objectArray[i], this._expirationTimeoutSeconds);
        }
    }

    public void setProperty(T t, String string, Object object) {
        HashMap<T, ExpirableData> hashMap = this.getMapForProperty(string);
        this.setPropertyOnMap(hashMap, t, object, this._expirationTimeoutSeconds);
    }

    private HashMap<T, ExpirableData> getMapForProperty(String string) {
        ConcurrentHashMap<String, HashMap<T, ExpirableData>> concurrentHashMap = this.getRootMap();
        if (!concurrentHashMap.containsKey(string)) {
            concurrentHashMap.putIfAbsent(string, new HashMap());
        }
        return concurrentHashMap.get(string);
    }

    private <C> C getPropertyFromMap(HashMap<T, ExpirableData> hashMap, T t) {
        if (!hashMap.containsKey(t)) {
            return null;
        }
        ExpirableData expirableData = hashMap.get(t);
        if (!expirableData.hasNotExpired()) {
            return null;
        }
        return (C)expirableData.data;
    }

    protected abstract ConcurrentHashMap<String, HashMap<T, ExpirableData>> getRootMap();

    private void setPropertyOnMap(HashMap<T, ExpirableData> hashMap, T t, Object object, int n) {
        hashMap.put(t, new ExpirableData(n, object));
    }

    protected static class ExpirableData {
        final long expirationTimestamp;
        final Object data;

        ExpirableData(int n, Object object) {
            this.expirationTimestamp = System.nanoTime() + 1000000000L * (long)n;
            this.data = object;
        }

        boolean hasNotExpired() {
            return System.nanoTime() < this.expirationTimestamp;
        }
    }
}

