/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.vim.cloudvm.SystemStats;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.VmInfo;
import com.vmware.vsphere.client.cm.util.HealthStateComparator;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.ServerPropertyValueExtractor;
import java.util.Comparator;

public final class ServerComparator
implements Comparator<InternalServerInfo> {
    private final OrderingCriteria _orderingCriteria;
    private final ServerPropertyValueExtractor _serverValueExtractor;

    public ServerComparator(OrderingCriteria orderingCriteria, ServerPropertyValueExtractor serverPropertyValueExtractor) {
        this._orderingCriteria = orderingCriteria;
        this._serverValueExtractor = serverPropertyValueExtractor;
    }

    @Override
    public int compare(InternalServerInfo internalServerInfo, InternalServerInfo internalServerInfo2) {
        for (OrderingPropertySpec orderingPropertySpec : this._orderingCriteria.orderingProperties) {
            for (String string : orderingPropertySpec.propertyNames) {
                int n;
                Object object = this.extractServerPropertyValue(internalServerInfo, string);
                Object object2 = this.extractServerPropertyValue(internalServerInfo2, string);
                int n2 = 0;
                if (object == null && object2 == null || (n2 = object == null ? 1 : (object2 == null ? -1 : (object instanceof HealthState ? this.compareByHealth((HealthState)((Object)object), (HealthState)((Object)object2)) : (object instanceof Comparable ? (n = ((Comparable)object).compareTo(object2)) : (object instanceof SystemStats ? this.compareByUptime((SystemStats)object, (SystemStats)object2) : (object instanceof VmInfo ? this.compareByVm((VmInfo)((Object)object), (VmInfo)((Object)object2)) : object.toString().compareToIgnoreCase(object2.toString()))))))) == 0) continue;
                return orderingPropertySpec.orderingType == SortType.ASCENDING ? n2 : -n2;
            }
        }
        return 0;
    }

    private int compareByHealth(HealthState healthState, HealthState healthState2) {
        return HealthStateComparator.getInstance().compare(healthState, healthState2);
    }

    private int compareByUptime(SystemStats systemStats, SystemStats systemStats2) {
        return Double.compare(systemStats.uptime, systemStats2.uptime);
    }

    private int compareByVm(VmInfo vmInfo, VmInfo vmInfo2) {
        return vmInfo.name.compareTo(vmInfo2.name);
    }

    private Object extractServerPropertyValue(InternalServerInfo internalServerInfo, String string) {
        return this._serverValueExtractor.getValues(new InternalServerInfo[]{internalServerInfo}, new String[]{string})[0][0];
    }
}

