/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.srs.impl;

import com.vmware.cis.common.sso.SsoOverRestHelper;
import com.vmware.cis.common.sso.SsoOverRestRequest;
import com.vmware.cis.services.common.sso.SsoOverRestHelper;
import com.vmware.opsmgmt.client.srs.impl.SrsServiceDescriptor;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.http.Request;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.http.CommonsHttpClient;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.http.SimpleHttpClient;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoUtil;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.PrivateKey;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SrsPingTask
implements Runnable {
    private static final Log _logger = LogFactory.getLog(SrsPingTask.class);
    private static final long TIMEOUT_EXCEPTIONS_STACK_TRACE_LOGGING_INTERVAL = 511L;
    private static final AtomicLong _timeoutExceptionsCounter = new AtomicLong(0L);
    private static final int HEADER_CHUNK_SIZE_BYTES = 1024;
    private final String _hashedClientId;
    private final String _clientId;
    private final SrsServiceDescriptor _service;
    private final int _timeout;
    private final KeystoreService _keystoreService;
    private final SSLConfigurationProvider _sslConfigProvider;
    private ScheduledFuture<?> _handle;

    public static SrsPingTask newInstance(SrsServiceDescriptor srsServiceDescriptor, String string, int n, KeystoreService keystoreService, SSLConfigurationProvider sSLConfigurationProvider) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{srsServiceDescriptor, string, keystoreService, sSLConfigurationProvider});
        String string2 = SessionUtil.getHashedClientId((String)string);
        if (string2 == null) {
            throw new IllegalArgumentException("hashedClientId is null");
        }
        return new SrsPingTask(string, string2, srsServiceDescriptor, n, keystoreService, sSLConfigurationProvider);
    }

    private SrsPingTask(String string, String string2, SrsServiceDescriptor srsServiceDescriptor, int n, KeystoreService keystoreService, SSLConfigurationProvider sSLConfigurationProvider) {
        this._clientId = string;
        this._hashedClientId = string2;
        this._service = srsServiceDescriptor;
        this._timeout = n;
        this._keystoreService = keystoreService;
        this._sslConfigProvider = sSLConfigurationProvider;
        this._handle = null;
    }

    public String getClientId() {
        return this._clientId;
    }

    public String getServiceId() {
        return this._service.getServiceId();
    }

    public SrsServiceDescriptor getService() {
        return this._service;
    }

    public void setHandle(ScheduledFuture<?> scheduledFuture) {
        if (this._handle != null) {
            throw new IllegalStateException("Task handle has already been set.");
        }
        this._handle = scheduledFuture;
    }

    @Override
    public void run() {
        try {
            HttpClient httpClient = this.getHttpClient();
            if (httpClient == null) {
                return;
            }
            httpClient.setSocketReadTimeout(this._timeout);
            String string = this._service.getLoginUrl();
            Map map = SsoOverRestHelper.calcAuthHeader((SsoOverRestRequest)new SsoOverRestRequest(SrsPingTask.getRequestMethod(httpClient), new URL(string), null), (PrivateKey)SsoUtil.getSolutionUser().getPrivateKey(), (SamlToken)AuthSessionUtil.getSsoToken((String)this._clientId), (int)1024);
            long l = System.currentTimeMillis();
            httpClient.executeMethod(string, null, map);
            int n = httpClient.getStatusCode();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)String.format("serviceId=%s; hashedClientId=%s; status=%s; time=%sms.", this._service.getServiceId(), this._hashedClientId, n, System.currentTimeMillis() - l));
            }
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof SocketTimeoutException) {
                this.logMessage(false, "Ping timed out", exception);
            }
            if (throwable instanceof SsoOverRestHelper.SsoOverRestHelperException) {
                this.logMessage(true, "Invalid session. Task execution will be suppressed", exception);
                throw new RuntimeException();
            }
            this.logMessage(true, "Unrecoverable error. Task execution will be suppressed", exception);
            throw new RuntimeException();
        }
    }

    public boolean cancel() {
        return this._handle.cancel(false);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this._clientId.hashCode();
        n = 31 * n + this._service.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SrsPingTask)) {
            return false;
        }
        SrsPingTask srsPingTask = (SrsPingTask)object;
        return this._clientId.equals(srsPingTask.getClientId()) && this._service.equals(srsPingTask.getService());
    }

    private HttpClient getHttpClient() {
        try {
            return new SSLBuilder().sslConfigurationProvider(this._sslConfigProvider).addTrustStore(this._keystoreService.getKeyStore()).buildHttpClient();
        }
        catch (Exception exception) {
            this.logMessage(true, "Failed to build HttpClient", exception);
            return null;
        }
    }

    private static Request.Method getRequestMethod(HttpClient httpClient) {
        Request.Method method;
        if (httpClient instanceof SimpleHttpClient) {
            method = Request.Method.GET;
        } else if (httpClient instanceof CommonsHttpClient) {
            method = Request.Method.POST;
        } else {
            _logger.error((Object)"Unable to determine request method, default to GET.");
            method = Request.Method.GET;
        }
        return method;
    }

    private void logMessage(boolean bl, String string, Exception exception) {
        string = String.format("%s for hashedClientId: %s and perfcharts serviceId: %s.\n", string, this._hashedClientId, this._service.getServiceId());
        if (bl) {
            _logger.error((Object)string, (Throwable)exception);
        } else if ((_timeoutExceptionsCounter.getAndIncrement() & 0x1FFL) == 0L) {
            _logger.warn((Object)string, (Throwable)exception);
        } else {
            _logger.warn((Object)(string + exception.getMessage()));
        }
    }
}

