/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.srs.impl;

import com.vmware.opsmgmt.client.srs.SrsProperties;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.cis.cm.site.Folder;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ExtensionManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SrsPropertiesProvider
implements PropertyProviderBean {
    private static final Log LOGGER = LogFactory.getLog(SrsPropertiesProvider.class);
    private static final String SRS_EXTENSION_KEY = "com.vmware.vim.stats.report";
    private static final Object LOCK_FOR_PERFCHARTS_URL_AND_VERSION = new Object();
    private static final String SRS_PARAM_SERVICE_URL = "serviceUrl";
    private static final String SRS_PARAM_SESSION_ID = "sessionId";
    private static final String SRS_PARAM_MOREF = "moref";
    private static final String SRS_PARAM_LOCALE = "locale";
    private static final Map<String, String> PERFCHARTS_GUID_URL_MAP = new HashMap<String, String>();
    private static final Map<String, String> PERFCHARTS_GUID_VERSION_MAP = new HashMap<String, String>();
    private ComponentManagerService _componentManagerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPerfchartsServiceVersionOneDotOne(String string) {
        String string2 = PERFCHARTS_GUID_VERSION_MAP.get(string);
        if (string2 == null) {
            Object object = LOCK_FOR_PERFCHARTS_URL_AND_VERSION;
            synchronized (object) {
                string2 = PERFCHARTS_GUID_VERSION_MAP.get(string);
            }
        }
        return "1.1".equals(string2);
    }

    public SrsPropertiesProvider(ComponentManagerService componentManagerService) {
        this._componentManagerService = componentManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @type(value="Datacenter,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Datastore,StoragePod")
    public SrsProperties getSrsProperties(ManagedObjectReference managedObjectReference) {
        Object object;
        String string = managedObjectReference.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)string);
        String string2 = PERFCHARTS_GUID_URL_MAP.get(string);
        if (string2 == null) {
            object = LOCK_FOR_PERFCHARTS_URL_AND_VERSION;
            synchronized (object) {
                string2 = PERFCHARTS_GUID_URL_MAP.get(string);
                if (string2 == null) {
                    if (this._componentManagerService != null && VcServiceUtil.is2014VcOrLater((String)vcService.getServiceGuid())) {
                        try {
                            string2 = this.lookupPerfchartsServiceUrl(vcService);
                            PERFCHARTS_GUID_URL_MAP.put(string, string2);
                            LOGGER.debug((Object)("Perfcharts URL extracted from the Component Manager : " + string2));
                        }
                        catch (ComponentManagerFault componentManagerFault) {
                            LOGGER.error((Object)componentManagerFault);
                        }
                    }
                    if (string2 == null) {
                        string2 = this.resolveSrsExtensionUrl(vcService);
                        PERFCHARTS_GUID_URL_MAP.put(string, string2);
                        LOGGER.debug((Object)("Perfcharts URL extracted from the Extension Manager : " + string2));
                    }
                }
            }
        }
        object = new SrsProperties();
        ((SrsProperties)((Object)object)).srsVersion = SrsPropertiesProvider.isPerfchartsServiceVersionOneDotOne(string) ? "1.1" : "1.0";
        ((SrsProperties)((Object)object)).srsEntryUrl = this.getSrsEntryUrl(string2, managedObjectReference, vcService);
        ((SrsProperties)((Object)object)).srsContextUrl = this.getSrsContextUrl(string2);
        ((SrsProperties)((Object)object)).srsBaseUrl = this.getSrsBaseUrl(string2);
        return object;
    }

    private String lookupPerfchartsServiceUrl(VcService vcService) throws ComponentManagerFault {
        ServiceTypeImpl serviceTypeImpl = new ServiceTypeImpl("com.vmware.cis", "cs.perfcharts");
        String string = vcService.getServiceGuid();
        ServiceInfo serviceInfo = this._componentManagerService.getService(string);
        Folder folder = serviceInfo.getFolder();
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl((ServiceType)serviceTypeImpl, folder, null, null, null);
        ServiceInfo[] serviceInfoArray = this._componentManagerService.search((SearchCriteria)searchCriteriaImpl);
        if (serviceInfoArray.length > 0) {
            ServiceEndPoint[] serviceEndPointArray;
            ServiceInfo serviceInfo2 = serviceInfoArray[0];
            String string2 = serviceInfo2.getServiceVersion();
            PERFCHARTS_GUID_VERSION_MAP.put(string, string2);
            for (ServiceEndPoint serviceEndPoint : serviceEndPointArray = serviceInfo2.getServiceEndPoints()) {
                String string3 = serviceEndPoint.getEndPointType().getTypeId();
                if (!"com.vmware.perfcharts.entry.url".equals(string3)) continue;
                return serviceEndPoint.getUrl().toString();
            }
        }
        return null;
    }

    private String getSrsEntryUrl(String string, ManagedObjectReference managedObjectReference, VcService vcService) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("?");
        stringBuilder.append(SRS_PARAM_MOREF).append("=").append(managedObjectReference.getType()).append(":").append(managedObjectReference.getValue());
        stringBuilder.append("&");
        stringBuilder.append(SRS_PARAM_LOCALE).append("=").append(ResourceUtil.getLocale());
        if (!SrsPropertiesProvider.isPerfchartsServiceVersionOneDotOne(managedObjectReference.getServerGuid())) {
            stringBuilder.append("&");
            stringBuilder.append(SRS_PARAM_SESSION_ID).append("=").append(vcService.getConnectionInfo().getSessionCookie());
            stringBuilder.append("&");
            stringBuilder.append(SRS_PARAM_SERVICE_URL).append("=").append(vcService.getServiceUrl());
        }
        return stringBuilder.toString();
    }

    private String getSrsContextUrl(String string) {
        String string2 = string.substring(0, string.lastIndexOf(47) + 1);
        return string2;
    }

    private String getSrsBaseUrl(String string) throws RuntimeException {
        try {
            URL uRL = new URL(string);
            URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "/");
            return uRL2.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("SRS extension url is not valid.", malformedURLException);
        }
    }

    private String resolveSrsExtensionUrl(VcService vcService) throws RuntimeException {
        String string;
        String string2 = this.getSrsExtensionUrl(this.getExtensionManager(vcService));
        try {
            string = new URL(vcService.getServiceUrl()).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Could not extract VC host from VC serviceUrl property.", malformedURLException);
        }
        return string2.replace("*", string);
    }

    private String getSrsExtensionUrl(ExtensionManager extensionManager) throws RuntimeException {
        Extension extension = extensionManager.findExtension(SRS_EXTENSION_KEY);
        if (extension == null) {
            throw new RuntimeException("SRS is not registered as VC extension.");
        }
        Extension.ServerInfo[] serverInfoArray = extension.getServer();
        if (serverInfoArray == null || serverInfoArray.length == 0) {
            throw new RuntimeException("SRS does not register any ServerInfo entries.");
        }
        String string = serverInfoArray[0].getUrl();
        return string;
    }

    private ExtensionManager getExtensionManager(VcService vcService) {
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        ManagedObjectReference managedObjectReference = serviceInstanceContent.getExtensionManager();
        return (ExtensionManager)vcService.getManagedObject(managedObjectReference);
    }
}

