/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.commons.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.wsdlName;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MorUtil {
    private static final Pattern URI_FORMAT = Pattern.compile("([\\p{Alnum}_-]+):([\\p{Alnum}_-]+)");

    private MorUtil() {
    }

    public static ManagedObjectReference buildMor(String string, String string2, String string3) {
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setServerGuid(string);
        managedObjectReference.setType(string2);
        managedObjectReference.setValue(string3);
        return managedObjectReference;
    }

    public static ManagedObjectReference buildMor(String string, Class<?> clazz, String string2) throws RuntimeException {
        wsdlName wsdlName2 = clazz.getAnnotation(wsdlName.class);
        if (wsdlName2 == null) {
            throw new RuntimeException(clazz.getName() + " class is not a valid binding");
        }
        String string3 = wsdlName2.value();
        return MorUtil.buildMor(string, string3, string2);
    }

    @Deprecated
    public static ManagedObjectReference buildMor(String string, String string2) {
        Matcher matcher = URI_FORMAT.matcher(string2);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Uri format is incorrect: " + string2 + ". Expected format is: <MO_type>:<MO_value>");
        }
        return MorUtil.buildMor(string, matcher.group(1), matcher.group(2));
    }

    @Deprecated
    public static URI toURI(ManagedObjectReference managedObjectReference) throws URISyntaxException {
        return new URI(managedObjectReference.getType() + ":" + managedObjectReference.getValue());
    }
}

