/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.interposition;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.interposition.InterposerConfig;
import com.vmware.vapi.interposition.OperationInvocationInfo;
import com.vmware.vapi.security.AuthenticationHandler;
import com.vmware.vapi.security.PrincipalId;

public final class InterposerUtil {
    public static final String PARAM_INVOCATION_REQUEST = "invocation_request";
    public static final String PARAM_INVOCATION_RESULT = "invocation_result";
    public static final String STRUCT_INVOCATION_REQUEST = "com.vmware.vapi.std.interposition.invocation_request";
    public static final String FIELD_INVOCATION_REQUEST_SERVICE_ID = "service_id";
    public static final String FIELD_INVOCATION_REQUEST_OPERATION_ID = "operation_id";
    public static final String FIELD_INVOCATION_REQUEST_OPERATION_INPUT = "operation_input";
    public static final String FIELD_INVOCATION_REQUEST_USER = "user";
    public static final String FIELD_INVOCATION_REQUEST_GROUPS = "groups";
    public static final String STRUCT_INVOCATION_RESULT = "com.vmware.vapi.std.interposition.invocation_result";
    public static final String ENUM_INVOCATION_RESULT_TYPE_NORMAL = "NORMAL_RESULT";
    public static final String ENUM_INVOCATION_RESULT_TYPE_ERROR = "ERROR_RESULT";
    public static final String FIELD_INVOCATION_RESULT_TYPE = "result_type";
    public static final String FIELD_INVOCATION_RESULT_OUTPUT = "output";
    public static final String FIELD_INVOCATION_RESULT_ERROR = "error";
    public static final String STRUCT_SECURITY_PRINCIPAL = "com.vmware.vapi.std.interposition.security_principal";
    public static final String FIELD_SECURITY_PRINCIPAL_NAME = "name";
    public static final String FIELD_SECURITY_PRINCIPAL_DOMAIN = "domain";

    private InterposerUtil() {
    }

    public static String getOperationQualifiedId(InterposerConfig config) {
        return config.getServiceId() + "." + config.getOperationId();
    }

    static StructValue toValue(PrincipalId principal) {
        StructValue s = new StructValue(STRUCT_SECURITY_PRINCIPAL);
        s.setField(FIELD_SECURITY_PRINCIPAL_NAME, principal.getName());
        OptionalValue domainOptional = principal.getDomain() != null ? new OptionalValue((DataValue)new StringValue(principal.getDomain())) : new OptionalValue();
        s.setField(FIELD_SECURITY_PRINCIPAL_DOMAIN, (DataValue)domainOptional);
        return s;
    }

    private static AuthenticationHandler.AuthenticationResult getAuthenticationInfo(OperationInvocationInfo operationInfo) {
        return InterposerUtil.getAuthenticationInfo(operationInfo.getExecutionContext());
    }

    private static AuthenticationHandler.AuthenticationResult getAuthenticationInfo(ExecutionContext ctx) {
        return InterposerUtil.getAuthenticationInfo(ctx.retrieveSecurityContext());
    }

    private static AuthenticationHandler.AuthenticationResult getAuthenticationInfo(ExecutionContext.SecurityContext ctx) {
        return ctx != null ? (AuthenticationHandler.AuthenticationResult)ctx.getProperty("authn_data_id") : null;
    }

    private static OptionalValue toUserValue(AuthenticationHandler.AuthenticationResult auth) {
        if (auth == null) {
            return new OptionalValue();
        }
        if (auth.getUser() == null) {
            return new OptionalValue();
        }
        return new OptionalValue((DataValue)InterposerUtil.toValue(auth.getUser()));
    }

    private static ListValue toGroupsValue(AuthenticationHandler.AuthenticationResult auth) {
        if (auth == null) {
            return new ListValue();
        }
        if (auth.getGroups() == null) {
            return new ListValue();
        }
        ListValue list = new ListValue();
        for (PrincipalId group : auth.getGroups()) {
            list.add((DataValue)InterposerUtil.toValue(group));
        }
        return list;
    }

    static StructValue toValue(MethodResult result) {
        StructValue s = new StructValue(STRUCT_INVOCATION_RESULT);
        if (result.success()) {
            s.setField(FIELD_INVOCATION_RESULT_TYPE, ENUM_INVOCATION_RESULT_TYPE_NORMAL);
            s.setField(FIELD_INVOCATION_RESULT_OUTPUT, (DataValue)new OptionalValue(result.getOutput()));
            s.setField(FIELD_INVOCATION_RESULT_ERROR, (DataValue)new OptionalValue());
        } else {
            s.setField(FIELD_INVOCATION_RESULT_TYPE, ENUM_INVOCATION_RESULT_TYPE_ERROR);
            s.setField(FIELD_INVOCATION_RESULT_OUTPUT, (DataValue)new OptionalValue());
            s.setField(FIELD_INVOCATION_RESULT_ERROR, (DataValue)new OptionalValue((DataValue)result.getError()));
        }
        return s;
    }

    static StructValue toValue(OperationInvocationInfo operationInfo) {
        StructValue s = new StructValue(STRUCT_INVOCATION_REQUEST);
        s.setField(FIELD_INVOCATION_REQUEST_SERVICE_ID, operationInfo.getServiceId());
        s.setField(FIELD_INVOCATION_REQUEST_OPERATION_ID, operationInfo.getOperationId());
        s.setField(FIELD_INVOCATION_REQUEST_OPERATION_INPUT, operationInfo.getInput());
        AuthenticationHandler.AuthenticationResult auth = InterposerUtil.getAuthenticationInfo(operationInfo);
        s.setField(FIELD_INVOCATION_REQUEST_USER, (DataValue)InterposerUtil.toUserValue(auth));
        s.setField(FIELD_INVOCATION_REQUEST_GROUPS, (DataValue)InterposerUtil.toGroupsValue(auth));
        return s;
    }

    public static StructValue createInterposerInput(OperationInvocationInfo operationInfo, InterposerConfig interposer) {
        StructValue s = new StructValue("operation-input");
        s.setField(PARAM_INVOCATION_REQUEST, (DataValue)InterposerUtil.toValue(operationInfo));
        return s;
    }

    public static StructValue createPostInterposerInput(OperationInvocationInfo operationInfo, MethodResult operationResult, InterposerConfig interposer) {
        StructValue s = new StructValue("operation-input");
        s.setField(PARAM_INVOCATION_REQUEST, (DataValue)InterposerUtil.toValue(operationInfo));
        s.setField(PARAM_INVOCATION_RESULT, (DataValue)InterposerUtil.toValue(operationResult));
        return s;
    }
}

