/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.interposition;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.interposition.InterposerUtil;
import com.vmware.vapi.interposition.OperationInvocationInfo;
import com.vmware.vapi.interposition.PostInterposerConfig;
import com.vmware.vapi.std.StandardDataFactory;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostInterposition
implements ApiProvider {
    private static final Logger logger = LoggerFactory.getLogger(PostInterposition.class);
    private static final MessageFactory msgFactory = new MessageFactory(ResourceBundle.getBundle("common"));
    private final ApiProvider operationProvider;
    private final List<PostInterposerConfig> interposers;

    public PostInterposition(ApiProvider operationProvider, List<PostInterposerConfig> interposers) {
        Validate.notNull((Object)operationProvider);
        Validate.notNull(interposers);
        this.operationProvider = operationProvider;
        this.interposers = interposers;
    }

    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        OperationInvocationInfo operationInfo = new OperationInvocationInfo(serviceId, operationId, ctx, input);
        this.operationProvider.invoke(serviceId, operationId, input, ctx, (AsyncHandle)new OperationCallback(this.interposers, asyncHandle, operationInfo));
    }

    private static final class InterposerCallback
    extends AsyncHandle<MethodResult> {
        private final PostInterposerConfig interposer;
        private final OperationInvocationInfo operationInfo;

        public InterposerCallback(PostInterposerConfig interposer, OperationInvocationInfo operationInfo) {
            this.interposer = interposer;
            this.operationInfo = operationInfo;
        }

        public void updateProgress(DataValue progress) {
        }

        public void setResult(MethodResult result) {
            if (!logger.isDebugEnabled()) {
                return;
            }
            if (result.success()) {
                logger.debug("Post interposer '{}' completed successfully for operation '{}'", (Object)InterposerUtil.getOperationQualifiedId(this.interposer), (Object)this.operationInfo.getOperationQualifiedId());
            } else {
                logger.debug(String.format("Post interposer '%s' returned error for operation '%s': '%s'", InterposerUtil.getOperationQualifiedId(this.interposer), this.operationInfo.getOperationQualifiedId(), result.getError()));
            }
        }

        public void setError(RuntimeException error) {
            if (!logger.isDebugEnabled()) {
                return;
            }
            logger.debug(String.format("Post interposer '%s' failed for operation '%s'", InterposerUtil.getOperationQualifiedId(this.interposer), this.operationInfo.getOperationQualifiedId()), (Throwable)error);
        }
    }

    private static final class OperationCallback
    extends AsyncHandle<MethodResult> {
        private final List<PostInterposerConfig> interposers;
        private final AsyncHandle<MethodResult> operationHandle;
        private final OperationInvocationInfo operationInfo;

        public OperationCallback(List<PostInterposerConfig> interposers, AsyncHandle<MethodResult> operationHandle, OperationInvocationInfo operationInfo) {
            this.interposers = interposers;
            this.operationHandle = operationHandle;
            this.operationInfo = operationInfo;
        }

        public void updateProgress(DataValue progress) {
            this.operationHandle.updateProgress(progress);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResult(MethodResult result) {
            try {
                this.operationHandle.setResult((Object)result);
            }
            finally {
                this.invokePostInterposers(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setError(RuntimeException error) {
            try {
                this.operationHandle.setError(error);
            }
            finally {
                this.invokePostInterposers(MethodResult.newErrorResult((ErrorValue)this.toErrorValue(error)));
            }
        }

        private ErrorValue toErrorValue(RuntimeException ex) {
            Message msg = msgFactory.buildMessage("vapi.interposition.post.operation.exception", new String[]{this.operationInfo.getOperationQualifiedId(), ex.getClass().getCanonicalName(), ex.getMessage()});
            return StandardDataFactory.createErrorValueForMessages((String)"com.vmware.vapi.std.errors.internal_server_error", Collections.singletonList(msg));
        }

        private void invokePostInterposers(MethodResult result) {
            for (PostInterposerConfig interposer : this.interposers) {
                interposer.getProvider().invoke(interposer.getServiceId(), interposer.getOperationId(), (DataValue)InterposerUtil.createPostInterposerInput(this.operationInfo, result, interposer), interposer.getExecutionContext(), (AsyncHandle)new InterposerCallback(interposer, this.operationInfo));
            }
        }
    }
}

