/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util.bindings;

import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.SetType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeReference;
import org.apache.commons.lang.Validate;

public class FieldTypeResolver {
    public static Type resolveFieldType(StructType structType, String compositeFieldName) {
        Validate.notNull((Object)structType);
        Validate.notEmpty((String)compositeFieldName);
        String[] namesTokens = compositeFieldName.split("/");
        if (namesTokens.length == 0) {
            throw new IllegalArgumentException(String.format("Invalid field name '%s': contains no simple names.", compositeFieldName));
        }
        StructType typeOfContainingStruct = structType;
        int indexOfLastFieldName = namesTokens.length - 1;
        for (int i = 0; i < indexOfLastFieldName; ++i) {
            String fieldName = namesTokens[i];
            FieldTypeResolver.verifyFieldName(compositeFieldName, fieldName);
            typeOfContainingStruct = FieldTypeResolver.resolveStructTypeOfFieldBySimpleName(typeOfContainingStruct, fieldName);
        }
        String lastFieldName = namesTokens[indexOfLastFieldName];
        FieldTypeResolver.verifyFieldName(compositeFieldName, lastFieldName);
        Type result = FieldTypeResolver.resolveTypeOfFieldBySimpleName(typeOfContainingStruct, lastFieldName);
        if (result instanceof TypeReference) {
            TypeReference ref = (TypeReference)result;
            result = ref.resolve();
        }
        return result;
    }

    private static void verifyFieldName(String compositeFieldName, String fieldName) {
        if (fieldName.isEmpty()) {
            throw new IllegalArgumentException(String.format("Field name '%s' contains an empty part", compositeFieldName));
        }
    }

    private static Type resolveTypeOfFieldBySimpleName(StructType typeOfContainingStruct, String fieldName) {
        Type fieldType = typeOfContainingStruct.getField(fieldName);
        if (fieldType == null) {
            fieldType = typeOfContainingStruct.getFieldByJavaName(fieldName);
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Structure '%s' does not contain field '%s'", typeOfContainingStruct.getName(), fieldName));
        }
        return fieldType;
    }

    private static StructType resolveStructTypeOfFieldBySimpleName(StructType typeOfContainingStruct, String fieldName) {
        Type fieldType = FieldTypeResolver.resolveTypeOfFieldBySimpleName(typeOfContainingStruct, fieldName);
        StructType result = null;
        while (result == null) {
            if (fieldType instanceof StructType) {
                result = (StructType)fieldType;
                continue;
            }
            if (fieldType instanceof OptionalType) {
                OptionalType optionalType = (OptionalType)fieldType;
                fieldType = optionalType.getElementType();
                continue;
            }
            if (fieldType instanceof ListType) {
                ListType listType = (ListType)fieldType;
                fieldType = listType.getElementType();
                continue;
            }
            if (fieldType instanceof SetType) {
                SetType setType = (SetType)fieldType;
                fieldType = setType.getElementType();
                continue;
            }
            if (fieldType instanceof TypeReference) {
                TypeReference ref = (TypeReference)fieldType;
                fieldType = ref.resolve();
                continue;
            }
            throw new IllegalArgumentException(String.format("Field '%s' of structure '%s' cannot be resolved to a structure type", fieldName, typeOfContainingStruct.getName()));
        }
        return result;
    }
}

