/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.interposition.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class InterposerSpec {
    public static final String PACKAGE_MATCH_ALL = "";
    private final String serviceId;
    private final String operationId;
    private final String operationQualifiedId;
    private final List<String> packages;

    public InterposerSpec(String serviceId, String operationId, List<String> packages) {
        Validate.notEmpty((String)serviceId);
        Validate.notEmpty((String)operationId);
        Validate.noNullElements(packages);
        this.serviceId = serviceId;
        this.operationId = operationId;
        this.packages = Collections.unmodifiableList(new ArrayList<String>(packages));
        this.operationQualifiedId = serviceId + "." + operationId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getOperationQualifiedId() {
        return this.operationQualifiedId;
    }

    public boolean matchesOperation(String operationQualifiedId) {
        Validate.notEmpty((String)operationQualifiedId);
        for (String pkg : this.packages) {
            if (!operationQualifiedId.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

