/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.cache.impl;

import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.CacheInvalidateCallback;
import com.vmware.cis.license.common.cache.impl.LruCacheImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SimpleTimeBasedCacheImpl<K, V>
implements Cache<K, V> {
    private final ReentrantReadWriteLock _rwLock = new ReentrantReadWriteLock();
    private final long _expirationIntervalMs;
    private final Map<K, V> _table;
    private final CacheInvalidateCallback<V> _invalidateCallback;
    private Date _lastCacheInvalidation;

    public SimpleTimeBasedCacheImpl(long expirationIntervalMs, int capacity) {
        this(expirationIntervalMs, capacity, null);
    }

    public SimpleTimeBasedCacheImpl(long expirationIntervalMs, int capacity, CacheInvalidateCallback<V> invalidateCallback) {
        this._expirationIntervalMs = expirationIntervalMs;
        this._table = new LruCacheImpl.LruTable(capacity);
        this._invalidateCallback = invalidateCallback;
        this._lastCacheInvalidation = new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        this.invalidateCacheIfExpired();
        this._rwLock.writeLock().lock();
        try {
            this._table.put(key, value);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.invalidateCacheIfExpired();
        this._rwLock.readLock().lock();
        try {
            V v = this._table.get(key);
            return v;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(K key) {
        this.invalidateCacheIfExpired();
        this._rwLock.readLock().lock();
        try {
            boolean bl = this._table.containsKey(key);
            return bl;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(K key) {
        this.invalidateCacheIfExpired();
        Object value = null;
        this._rwLock.writeLock().lock();
        try {
            value = this._table.remove(key);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
        if (this._invalidateCallback != null && value != null) {
            this._invalidateCallback.cacheValueInvalidated(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        ArrayList<V> valuesCopy = null;
        this._rwLock.writeLock().lock();
        try {
            if (this._invalidateCallback != null) {
                valuesCopy = new ArrayList<V>(this._table.values());
            }
            this._table.clear();
            this._lastCacheInvalidation = new Date();
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
        if (this._invalidateCallback != null && valuesCopy != null) {
            for (V value : valuesCopy) {
                this._invalidateCallback.cacheValueInvalidated(value);
            }
        }
    }

    private void invalidateCacheIfExpired() {
        if (this.isCacheExpired()) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCacheExpired() {
        this._rwLock.readLock().lock();
        try {
            Date cacheExpirationTime = new Date(this._lastCacheInvalidation.getTime() + this._expirationIntervalMs);
            Date now = new Date();
            boolean bl = now.after(cacheExpirationTime);
            return bl;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }
}

