/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.cert;

import com.vmware.cis.license.common.cert.CertificateLoadException;
import com.vmware.cis.license.common.misc.CodecUtil;
import com.vmware.cis.license.common.misc.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class CertUtil {
    public static final String CERT_TYPE_X509 = "X.509";
    public static final String KEYSTORE_TYPE_JKS = "JKS";
    public static final String KEYSTORE_TYPE_VKS = "VKS";
    private static final String HEX = "0123456789ABCDEF";

    public static X509Certificate[] decodeCerts(String[] base64EncodedCerts) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance(CERT_TYPE_X509);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (String base64CertStr : base64EncodedCerts) {
            byte[] certBytes = CodecUtil.decodeBase64(base64CertStr);
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBytes));
            certificates.add(cert);
        }
        return certificates.toArray(new X509Certificate[certificates.size()]);
    }

    public static String[] getCertsThumbprints(X509Certificate[] certs) throws CertificateEncodingException, NoSuchAlgorithmException {
        ArrayList<String> thumbprints = new ArrayList<String>();
        for (X509Certificate cert : certs) {
            String thumbprint = CertUtil.computeCertificateThumbprint(cert);
            thumbprints.add(thumbprint);
        }
        return thumbprints.toArray(new String[thumbprints.size()]);
    }

    public static KeyStore createKeyStore(X509Certificate cert, String alias) {
        KeyStore trustStore = null;
        try {
            trustStore = KeyStore.getInstance(KEYSTORE_TYPE_JKS);
            trustStore.load(null);
            trustStore.setEntry(alias, new KeyStore.TrustedCertificateEntry(cert), null);
        }
        catch (Exception e) {
            LogUtil.logUnexpectedError("Failed to create trustStore from SSL certificates. About to create HttpConfiguration with NO trustStore and/or thumbprint verifier", e);
        }
        return trustStore;
    }

    public static String stripBase64EncodedCert(String base64EncodedCert) {
        base64EncodedCert = base64EncodedCert.replaceAll("\n", "");
        base64EncodedCert = base64EncodedCert.replaceAll("-----BEGIN CERTIFICATE-----", "");
        base64EncodedCert = base64EncodedCert.replaceAll("-----END CERTIFICATE-----", "");
        return base64EncodedCert;
    }

    public static String computeCertificateThumbprint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] digest = md.digest(cert.getEncoded());
        StringBuilder thumbprint = new StringBuilder();
        int len = digest.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                thumbprint.append(':');
            }
            byte b = digest[i];
            thumbprint.append(HEX.charAt((b & 0xF0) >> 4));
            thumbprint.append(HEX.charAt(b & 0xF));
        }
        return thumbprint.toString();
    }

    public static KeyStore loadKeyStore(String type, KeyStore.LoadStoreParameter loadStoreParameter) throws CertificateLoadException {
        try {
            KeyStore keyStore = KeyStore.getInstance(type);
            keyStore.load(loadStoreParameter);
            return keyStore;
        }
        catch (Exception e) {
            throw new CertificateLoadException(e);
        }
    }

    public static KeyStore loadKeyStore(URL location, String password, String type) throws CertificateLoadException {
        InputStream keystoreStream = null;
        try {
            keystoreStream = location != null ? location.openStream() : null;
            char[] keystorePassword = password != null ? password.toCharArray() : null;
            KeyStore keyStore = CertUtil.loadKeyStore(keystoreStream, keystorePassword, type);
            return keyStore;
        }
        catch (Exception e) {
            throw new CertificateLoadException(e);
        }
        finally {
            if (keystoreStream != null) {
                try {
                    keystoreStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static KeyStore loadKeyStore(InputStream in, char[] password, String type) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(in, password);
        return keyStore;
    }
}

