/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.domain;

import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.impl.LruCacheImpl;
import com.vmware.cis.license.common.misc.Pair;
import com.vmware.cis.license.common.misc.Util;
import com.vmware.vim.binding.cis.license.Feature;
import com.vmware.vim.binding.cis.license.management.FeatureUsage;
import com.vmware.vim.binding.impl.cis.license.FeatureImpl;
import com.vmware.vim.binding.impl.cis.license.management.FeatureUsageImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class FeatureUtil {
    private static final int UNLIMITED_FEATURE_CAPACITY = 0;
    private static final Cache<String, FeatureImpl> _featureIdToFeatureCache = new LruCacheImpl<String, FeatureImpl>(40);

    public static final FeatureImpl buildFeature(String featureId) {
        FeatureImpl feature = _featureIdToFeatureCache.get(featureId);
        if (feature == null) {
            feature = new FeatureImpl(featureId);
            _featureIdToFeatureCache.put(featureId, feature);
        }
        return feature;
    }

    public static final FeatureUsage buildFeatureUsage(String featureId, boolean inUse) {
        FeatureUsage featureUsage = FeatureUtil.buildFeatureUsage((Feature)FeatureUtil.buildFeature(featureId), inUse);
        return featureUsage;
    }

    public static final FeatureUsage buildFeatureUsage(Feature feature, boolean inUse) {
        FeatureUsageImpl featureUsage = new FeatureUsageImpl();
        featureUsage.setFeature(feature);
        featureUsage.setInUse(inUse);
        return featureUsage;
    }

    public static FeatureUsage[] buildFeaturesUsageForRemove(List<Feature> featuresToRemove) {
        ArrayList<FeatureUsage> featuresUsage = new ArrayList<FeatureUsage>();
        for (Feature featureToRemove : featuresToRemove) {
            FeatureUsage featureUsage = FeatureUtil.buildFeatureUsage(featureToRemove, false);
            featuresUsage.add(featureUsage);
        }
        return featuresUsage.toArray(new FeatureUsage[featuresUsage.size()]);
    }

    public static boolean isFeatureSupported(Feature inUseFeature, Feature[] supportedCapacityFeatures) {
        if (Util.isNullOrEmpty(supportedCapacityFeatures)) {
            return false;
        }
        for (Feature supportedFeature : supportedCapacityFeatures) {
            if (!FeatureUtil.isFeatureIdAndCapacitySupported(inUseFeature.getId(), supportedFeature.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFeatureSupported(String inUseFeature, String[] supportedCapacityFeatures) {
        if (Util.isNullOrEmpty(supportedCapacityFeatures)) {
            return false;
        }
        for (String supportedFeature : supportedCapacityFeatures) {
            if (!FeatureUtil.isFeatureIdAndCapacitySupported(inUseFeature, supportedFeature)) continue;
            return true;
        }
        return false;
    }

    static boolean isFeatureIdAndCapacitySupported(String inUseFeature, String supportedCapacityFeature) {
        Pair<String, Integer> inUserFeaturePair = FeatureUtil.getFeatureIdAndValue(inUseFeature);
        Pair<String, Integer> supportedCapacityFeaturePair = FeatureUtil.getFeatureIdAndValue(supportedCapacityFeature);
        if (!inUserFeaturePair.getFirst().equals(supportedCapacityFeaturePair.getFirst())) {
            return false;
        }
        return supportedCapacityFeaturePair.getSecond() == 0 || inUserFeaturePair.getSecond() <= supportedCapacityFeaturePair.getSecond();
    }

    public static List<Feature> getUnsupportedFeatures(Feature[] inUseFeatures, Feature[] supportedCapacityFeatures) {
        if (Util.isNullOrEmpty(inUseFeatures)) {
            return null;
        }
        if (Util.isNullOrEmpty(supportedCapacityFeatures)) {
            return Arrays.asList(inUseFeatures);
        }
        ArrayList<Feature> unsupportedFeatures = new ArrayList<Feature>();
        for (Feature feature : inUseFeatures) {
            if (FeatureUtil.isFeatureSupported(feature, supportedCapacityFeatures)) continue;
            unsupportedFeatures.add(feature);
        }
        return unsupportedFeatures;
    }

    public static String[] getUnsupportedFeatures(String[] inUseFeatures, Feature[] supportedCapacityFeatures) {
        if (Util.isNullOrEmpty(inUseFeatures)) {
            return null;
        }
        if (Util.isNullOrEmpty(supportedCapacityFeatures)) {
            return inUseFeatures;
        }
        ArrayList<String> unsupportedFeatures = new ArrayList<String>();
        for (String featureId : inUseFeatures) {
            FeatureImpl feature = FeatureUtil.buildFeature(featureId);
            if (FeatureUtil.isFeatureSupported((Feature)feature, supportedCapacityFeatures)) continue;
            unsupportedFeatures.add(featureId);
        }
        return unsupportedFeatures.toArray(new String[unsupportedFeatures.size()]);
    }

    public static String[] getUnsupportedFeatures(String[] inUseFeatures, String[] supportedCapacityFeatures) {
        if (Util.isNullOrEmpty(inUseFeatures)) {
            return null;
        }
        if (Util.isNullOrEmpty(supportedCapacityFeatures)) {
            return inUseFeatures;
        }
        LinkedHashSet<String> conflictingFeaturesResult = new LinkedHashSet<String>();
        if (inUseFeatures != null) {
            for (String inUseFeature : inUseFeatures) {
                if (FeatureUtil.isFeatureSupported(inUseFeature, supportedCapacityFeatures)) continue;
                conflictingFeaturesResult.add(inUseFeature);
            }
        }
        return conflictingFeaturesResult.toArray(new String[conflictingFeaturesResult.size()]);
    }

    public static FeatureUsage[] buildFeaturesUsageForReplace(String[] newInUseFeatures, Feature[] existingInUseFeatures) {
        ArrayList<FeatureUsage> result = new ArrayList<FeatureUsage>();
        HashSet<String> realNewFeatureIds = new HashSet<String>();
        for (String string : newInUseFeatures) {
            FeatureUsage featureUsageToAdd = FeatureUtil.buildFeatureUsage(string, true);
            result.add(featureUsageToAdd);
            realNewFeatureIds.add(FeatureUtil.getFeatureIdAndValue(string).getFirst());
        }
        if (!Util.isNullOrEmpty(existingInUseFeatures)) {
            for (String string : existingInUseFeatures) {
                Pair<String, Integer> pair = FeatureUtil.getFeatureIdAndValue(string.getId());
                if (realNewFeatureIds.contains(pair.getFirst())) continue;
                FeatureUsage featureUsageToRemove = FeatureUtil.buildFeatureUsage((Feature)string, false);
                result.add(featureUsageToRemove);
            }
        }
        return result.toArray(new FeatureUsage[result.size()]);
    }

    public static String[] mergedFeaturesUsageForReplace(FeatureUsage[] newFeaturesUsage, String[] existingInUseFeatures) {
        Pair<String, Integer> pair;
        LinkedHashSet<String> mergedFeatureIds = new LinkedHashSet<String>();
        HashSet<String> realFeatureIdsToAdd = new HashSet<String>();
        HashSet<String> realFeatureIdsToRemove = new HashSet<String>();
        for (FeatureUsage featureUsage : newFeaturesUsage) {
            pair = FeatureUtil.getFeatureIdAndValue(featureUsage.getFeature().getId());
            if (featureUsage.isInUse()) {
                mergedFeatureIds.add(featureUsage.getFeature().getId());
                realFeatureIdsToAdd.add(pair.getFirst());
                continue;
            }
            realFeatureIdsToRemove.add(pair.getFirst());
        }
        if (!Util.isNullOrEmpty(existingInUseFeatures)) {
            for (String string : existingInUseFeatures) {
                pair = FeatureUtil.getFeatureIdAndValue(string);
                if (realFeatureIdsToAdd.contains(pair.getFirst()) || realFeatureIdsToRemove.contains(pair.getFirst())) continue;
                mergedFeatureIds.add(string);
            }
        }
        return mergedFeatureIds.toArray(new String[mergedFeatureIds.size()]);
    }

    public static String[] getFeatureIds(Feature[] features) {
        ArrayList<String> featureIds = new ArrayList<String>();
        if (!Util.isNullOrEmpty(features)) {
            for (Feature cisInUseFeature : features) {
                featureIds.add(cisInUseFeature.getId());
            }
        }
        return featureIds.toArray(new String[featureIds.size()]);
    }

    public static String[] getFeatureIds(FeatureUsage[] featuresUsage) {
        ArrayList<String> featureIds = new ArrayList<String>();
        for (FeatureUsage usage : featuresUsage) {
            featureIds.add(usage.getFeature().getId());
        }
        return featureIds.toArray(new String[featureIds.size()]);
    }

    public static List<String> getFeatureIdsAsList(FeatureUsage[] featuresUsage) {
        ArrayList<String> featureIds = new ArrayList<String>();
        for (FeatureUsage usage : featuresUsage) {
            featureIds.add(usage.getFeature().getId());
        }
        return featureIds;
    }

    static Pair<String, Integer> getFeatureIdAndValue(String feature) {
        String realFeatureId = feature;
        Integer value = 1;
        int sepIndex = feature.indexOf(":");
        if (sepIndex != -1) {
            realFeatureId = feature.substring(0, sepIndex);
            try {
                value = Integer.parseInt(feature.substring(sepIndex + 1));
            }
            catch (NumberFormatException e) {
                realFeatureId = feature;
                value = 1;
            }
        }
        return new Pair<String, Integer>(realFeatureId, value);
    }
}

