/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.domain;

import com.vmware.cis.license.common.domain.ProductUtil;
import com.vmware.cis.license.common.misc.Util;
import com.vmware.cis.license.common.misc.VersionUtil;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.AssetInfo;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.LicenseProductCapability;
import com.vmware.vim.binding.cis.license.LicenseProductRestriction;
import com.vmware.vim.binding.cis.license.ProductFamily;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class RestrictionUtil {
    public static LicenseProductRestriction getLicenseProductRestriction(Asset asset) {
        if (asset == null) {
            return null;
        }
        LicenseProductRestriction restriction = RestrictionUtil.getLicenseProductRestriction(asset.getInfo());
        return restriction;
    }

    public static LicenseProductRestriction getLicenseProductRestriction(AssetInfo assetInfo) {
        if (assetInfo == null || assetInfo.getLicense() == null) {
            return null;
        }
        License license = assetInfo.getLicense();
        LicenseProductRestriction[] restrictions = license.getInfo().getRestrictions();
        if (restrictions != null) {
            return restrictions[0];
        }
        return null;
    }

    public static LicenseProductRestriction getLicenseProductRestriction(LicenseInfo licenseInfo, ProductFamily restrictionProductFamily, String restrictionCapabilityVersion) {
        if (licenseInfo == null) {
            return null;
        }
        LicenseProductRestriction resultRestriction = null;
        LicenseProductRestriction[] restrictionsForProductFamily = RestrictionUtil.filterRestrictionsByProductFamily(licenseInfo.getRestrictions(), restrictionProductFamily);
        resultRestriction = Util.isNullOrEmpty(restrictionCapabilityVersion) ? RestrictionUtil.getRestrictionWithHighestCapabilityVersion(restrictionsForProductFamily) : RestrictionUtil.getRestrictionWithCapabilityVersion(restrictionsForProductFamily, restrictionCapabilityVersion);
        return resultRestriction;
    }

    public static LicenseProductCapability getLicenseProductCapability(Asset asset) {
        LicenseProductRestriction restriction = RestrictionUtil.getLicenseProductRestriction(asset);
        if (restriction == null) {
            return null;
        }
        LicenseProductCapability[] capabilities = restriction.getCapability();
        if (capabilities != null) {
            return capabilities[0];
        }
        return null;
    }

    public static LicenseProductCapability getProductCapability(String assetVersion, LicenseProductCapability[] capabilities) {
        LicenseProductCapability resultCapability = null;
        resultCapability = Util.isNullOrEmpty(assetVersion) ? RestrictionUtil.getCapabilityWithHighestVersion(capabilities) : RestrictionUtil.getCapabilityWithVersion(capabilities, assetVersion);
        return resultCapability;
    }

    public static LicenseProductRestriction getProductRestrictionForProduct(String productId, LicenseInfo licenseInfo) {
        if (Util.isNullOrEmpty(productId) || licenseInfo == null) {
            return null;
        }
        if ("Unlicensed".equals(productId)) {
            return null;
        }
        LicenseProductRestriction resultRestriction = null;
        for (LicenseProductRestriction restriction : licenseInfo.getRestrictions()) {
            if (!productId.equals(restriction.getProduct().getId())) continue;
            resultRestriction = restriction;
            break;
        }
        return resultRestriction;
    }

    public static LicenseProductRestriction[] filterRestrictionsByProductFamily(LicenseProductRestriction[] restrictions, ProductFamily productFamily) {
        ArrayList<LicenseProductRestriction> resultRestrictions = new ArrayList<LicenseProductRestriction>();
        if (restrictions == null) {
            return resultRestrictions.toArray(new LicenseProductRestriction[0]);
        }
        for (LicenseProductRestriction restriction : restrictions) {
            ProductFamily restrictionProductFamily = restriction.getProduct().getFamily();
            if (!ProductUtil.areProductFamiliesEqual(restrictionProductFamily, productFamily)) continue;
            resultRestrictions.add(restriction);
        }
        return resultRestrictions.toArray(new LicenseProductRestriction[0]);
    }

    public static LicenseProductRestriction[] filterRestrictionsByProductFamilyName(LicenseProductRestriction[] restrictions, String productFamilyName) {
        ArrayList<LicenseProductRestriction> resultRestrictions = new ArrayList<LicenseProductRestriction>();
        for (LicenseProductRestriction restriction : restrictions) {
            ProductFamily restrictionProductFamily = restriction.getProduct().getFamily();
            if (!restrictionProductFamily.getName().equals(productFamilyName)) continue;
            resultRestrictions.add(restriction);
        }
        return resultRestrictions.toArray(new LicenseProductRestriction[resultRestrictions.size()]);
    }

    public static boolean areEquivalentLicenseProductRestrictions(LicenseProductRestriction[] firstRestrictions, LicenseProductRestriction[] secondRestrictions) {
        if (Util.isNullOrEmpty(firstRestrictions) || Util.isNullOrEmpty(secondRestrictions)) {
            return Util.isNullOrEmpty(firstRestrictions) && Util.isNullOrEmpty(secondRestrictions);
        }
        if (firstRestrictions.length != secondRestrictions.length) {
            return false;
        }
        HashMap<String, LicenseProductRestriction> productIdToRestriction = new HashMap<String, LicenseProductRestriction>();
        for (LicenseProductRestriction firstRestriction : firstRestrictions) {
            productIdToRestriction.put(firstRestriction.getProduct().getId(), firstRestriction);
        }
        boolean areEquivalentRestrictions = true;
        for (LicenseProductRestriction secondRestriction : secondRestrictions) {
            LicenseProductRestriction firstRestriction = (LicenseProductRestriction)productIdToRestriction.get(secondRestriction.getProduct().getId());
            if (firstRestriction == null) {
                areEquivalentRestrictions = false;
                break;
            }
            boolean areEquivalentCapabilities = RestrictionUtil.areEquivalentLicenseProductCapabilities(firstRestriction.getCapability(), secondRestriction.getCapability());
            boolean areEquivalentCostUnits = RestrictionUtil.areEquivalentCostUnitLimits(firstRestriction.getCostUnitsLimit(), secondRestriction.getCostUnitsLimit());
            if (areEquivalentCapabilities && areEquivalentCostUnits) continue;
            areEquivalentRestrictions = false;
            break;
        }
        return areEquivalentRestrictions;
    }

    private static LicenseProductRestriction getRestrictionWithCapabilityVersion(LicenseProductRestriction[] restrictions, String capabilityVersion) {
        if (Util.isNullOrEmpty(restrictions)) {
            return null;
        }
        LicenseProductRestriction resultRestriction = null;
        for (LicenseProductRestriction restriction : restrictions) {
            LicenseProductCapability resultCapability = RestrictionUtil.getCapabilityWithVersion(restriction.getCapability(), capabilityVersion);
            if (resultCapability == null) continue;
            resultRestriction = restriction;
            break;
        }
        return resultRestriction;
    }

    private static LicenseProductRestriction getRestrictionWithHighestCapabilityVersion(LicenseProductRestriction[] restrictions) {
        if (Util.isNullOrEmpty(restrictions)) {
            return null;
        }
        LicenseProductRestriction resultRestriction = restrictions[0];
        String highestVersion = resultRestriction.getCapability()[0].getVersion();
        for (LicenseProductRestriction restriction : restrictions) {
            LicenseProductCapability highestVersionCapability = RestrictionUtil.getCapabilityWithHighestVersion(restriction.getCapability());
            if (VersionUtil.compareVersions(highestVersion, highestVersionCapability.getVersion()) >= 0) continue;
            resultRestriction = restriction;
            highestVersion = highestVersionCapability.getVersion();
        }
        return resultRestriction;
    }

    private static LicenseProductCapability getCapabilityWithVersion(LicenseProductCapability[] capabilities, String capabilityVersion) {
        LicenseProductCapability resultCapability = null;
        for (LicenseProductCapability capability : capabilities) {
            if (!capabilityVersion.equals(capability.getVersion())) continue;
            resultCapability = capability;
            break;
        }
        return resultCapability;
    }

    private static LicenseProductCapability getCapabilityWithHighestVersion(LicenseProductCapability[] capabilities) {
        LicenseProductCapability resultCapability = capabilities[0];
        String highestVersion = resultCapability.getVersion();
        for (LicenseProductCapability capability : capabilities) {
            if (VersionUtil.compareVersions(highestVersion, capability.getVersion()) >= 0) continue;
            resultCapability = capability;
            highestVersion = capability.getVersion();
        }
        return resultCapability;
    }

    private static boolean areEquivalentLicenseProductCapabilities(LicenseProductCapability[] firstCapabilities, LicenseProductCapability[] secondCapabilities) {
        if (Util.isNullOrEmpty(firstCapabilities) || Util.isNullOrEmpty(secondCapabilities)) {
            return Util.isNullOrEmpty(firstCapabilities) && Util.isNullOrEmpty(secondCapabilities);
        }
        if (firstCapabilities.length != secondCapabilities.length) {
            return false;
        }
        HashSet<String> firstCapabilityVersions = new HashSet<String>();
        for (LicenseProductCapability firstCapability : firstCapabilities) {
            firstCapabilityVersions.add(firstCapability.getVersion());
        }
        boolean areEquivalentCapabilities = true;
        for (LicenseProductCapability secondCapability : secondCapabilities) {
            if (firstCapabilityVersions.contains(secondCapability.getVersion())) continue;
            areEquivalentCapabilities = false;
            break;
        }
        return areEquivalentCapabilities;
    }

    private static boolean areEquivalentCostUnitLimits(CostUnitLimit[] firstCostUnitsLimits, CostUnitLimit[] secondCostUnitsLimits) {
        if (Util.isNullOrEmpty(firstCostUnitsLimits) || Util.isNullOrEmpty(secondCostUnitsLimits)) {
            return Util.isNullOrEmpty(firstCostUnitsLimits) && Util.isNullOrEmpty(secondCostUnitsLimits);
        }
        if (firstCostUnitsLimits.length != secondCostUnitsLimits.length) {
            return false;
        }
        HashSet<String> firstCostUnitIds = new HashSet<String>();
        for (CostUnitLimit firstCostUnitLimit : firstCostUnitsLimits) {
            firstCostUnitIds.add(firstCostUnitLimit.getUnit().getId());
        }
        boolean areEquivalentCostUnits = true;
        for (CostUnitLimit secondCostUnitLimit : secondCostUnitsLimits) {
            if (firstCostUnitIds.contains(secondCostUnitLimit.getUnit().getId())) continue;
            areEquivalentCostUnits = false;
            break;
        }
        return areEquivalentCostUnits;
    }
}

