/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.domain.myvmware;

import com.vmware.cis.license.common.domain.myvmware.LicenseKeyDetails;
import com.vmware.cis.license.common.domain.myvmware.impl.JsonLicenseKeyDetailsDeserializerImpl;
import com.vmware.cis.license.common.domain.myvmware.impl.JsonLicenseKeyDetailsSerializerImpl;
import com.vmware.cis.license.common.serialization.DeserializeException;
import com.vmware.cis.license.common.serialization.SerializeException;
import com.vmware.cis.license.common.serialization.impl.BaseDeserializer;
import com.vmware.cis.license.common.serialization.impl.BaseSerializer;
import com.vmware.cis.license.common.serialization.impl.GZipDeserializerWrapperImpl;
import com.vmware.cis.license.common.serialization.impl.GZipSerializerWrapperImpl;

public class EncodeUtil {
    public static final String LICENSE_METADATA_VERSION_DEV = "dev";

    public static byte[] encodeLicenseKeyDetails(LicenseKeyDetails licenseKeyDetails, String version) throws SerializeException {
        BaseSerializer<LicenseKeyDetails> jsonLicenseKeyDetailsSerializer = EncodeUtil.createJsonLicenseKeyDetailsSerializer(version);
        GZipSerializerWrapperImpl<LicenseKeyDetails> zipSerializerWrapper = new GZipSerializerWrapperImpl<LicenseKeyDetails>(jsonLicenseKeyDetailsSerializer);
        return zipSerializerWrapper.serializeData(licenseKeyDetails);
    }

    public static LicenseKeyDetails decodeLicenseKeyDetails(byte[] data, String version) throws DeserializeException {
        BaseDeserializer<LicenseKeyDetails> jsonLicenseKeyDetailsDeserializer = EncodeUtil.createJsonLicenseKeyDetailsDeserializer(version);
        GZipDeserializerWrapperImpl<LicenseKeyDetails> zipDeserializerWrapper = new GZipDeserializerWrapperImpl<LicenseKeyDetails>(jsonLicenseKeyDetailsDeserializer);
        return (LicenseKeyDetails)zipDeserializerWrapper.deserializeData(data);
    }

    private static BaseSerializer<LicenseKeyDetails> createJsonLicenseKeyDetailsSerializer(String version) throws SerializeException {
        if (!LICENSE_METADATA_VERSION_DEV.equals(version)) {
            throw new SerializeException("Unsupported version: " + version, null);
        }
        JsonLicenseKeyDetailsSerializerImpl jsonLicenseKeyDetailsSerializer = new JsonLicenseKeyDetailsSerializerImpl();
        return jsonLicenseKeyDetailsSerializer;
    }

    private static BaseDeserializer<LicenseKeyDetails> createJsonLicenseKeyDetailsDeserializer(String version) throws DeserializeException {
        if (!LICENSE_METADATA_VERSION_DEV.equals(version)) {
            throw new DeserializeException("Unsupported version: " + version);
        }
        JsonLicenseKeyDetailsDeserializerImpl jsonLicenseKeyDetailsDeserializer = new JsonLicenseKeyDetailsDeserializerImpl();
        return jsonLicenseKeyDetailsDeserializer;
    }
}

