/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.domain.myvmware;

import com.vmware.cis.license.common.misc.GZipUtil;
import com.vmware.vim.binding.cis.license.management.InactiveLicensesReport;
import com.vmware.vim.binding.cis.license.management.MyVMwareLicenseReport;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareLicenseReportImpl;
import com.vmware.vim.binding.impl.vmodl.BinaryImpl;
import com.vmware.vim.binding.vmodl.Binary;
import java.io.IOException;

public class LicenseReportUtil {
    private static final boolean DEFAULT_SHOULD_COMPRESS_REPORT = true;
    private static final boolean DEFAULT_SHOULD_DECOMPRESS_INACTIVE_REPORT = true;

    public static MyVMwareLicenseReport buildMyVMwareLicenseReport(byte[] reportByteArray) throws IOException {
        return LicenseReportUtil.buildMyVMwareLicenseReport(reportByteArray, true);
    }

    public static MyVMwareLicenseReport buildMyVMwareLicenseReport(byte[] reportByteArray, boolean shouldCompressReport) throws IOException {
        if (shouldCompressReport) {
            reportByteArray = GZipUtil.compressData(reportByteArray);
        }
        return new MyVMwareLicenseReportImpl((Binary)new BinaryImpl(reportByteArray));
    }

    public static byte[] getInactiveLicensesReportContent(InactiveLicensesReport inactiveLicensesReport) throws IOException {
        return LicenseReportUtil.getInactiveLicensesReportContent(inactiveLicensesReport, true);
    }

    public static byte[] getInactiveLicensesReportContent(InactiveLicensesReport inactiveLicensesReport, boolean shouldDecompress) throws IOException {
        byte[] result = inactiveLicensesReport.getData().asArray();
        if (shouldDecompress) {
            result = GZipUtil.decompressData(result);
        }
        return result;
    }
}

