/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.ft.impl;

import com.vmware.cis.license.common.ft.RetryStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RetryStrategyImpl
implements RetryStrategy {
    Log _log = LogFactory.getLog(RetryStrategyImpl.class);
    private final int _maxRetryAttempts;

    public RetryStrategyImpl(int maxRetryAttempts) {
        this._maxRetryAttempts = maxRetryAttempts;
    }

    @Override
    public final boolean shouldRetry(Exception exception, String operationName, int retryAttempt) {
        boolean shouldRetry;
        if (this._log.isWarnEnabled()) {
            this._log.warn((Object)String.format("Received error while executing operation %s. Will attempt to retry it. The error:\n%s", operationName, exception));
        }
        if (!this.isRetryAppropriate(exception, operationName)) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)String.format("Retrying operation %s not appropriate, the error is considered unrecoverable or expected.", operationName));
            }
            return false;
        }
        if (retryAttempt < this._maxRetryAttempts) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)String.format("Will try to retry operation: %s. Retry attempt %s of %s", operationName, retryAttempt + 1, this._maxRetryAttempts));
            }
            if (this.isNotAuthenticatedError(exception)) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"Retrying login...");
                }
                this.login();
            }
            shouldRetry = true;
        } else {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)String.format("Retry not appropriate for operation: %s. All %s retries have been attempted already.", operationName, this._maxRetryAttempts));
            }
            shouldRetry = false;
        }
        return shouldRetry;
    }

    @Override
    public final int getMaxRetryAttemtps() {
        return this._maxRetryAttempts;
    }
}

