/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;

public class Util {
    public static final String ENCODING_UTF_8 = "UTF-8";
    public static final String ENCODING_UTF_16 = "UTF-16";
    public static final int DEFAULT_BUF_SIZE = Short.MAX_VALUE;
    public static final int GB_TO_MB = 1024;
    public static final int TB_TO_GB = 1024;
    public static final int TB_TO_MB = 0x100000;

    public static <T> boolean isNullOrEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <K, V> boolean isNullOrEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.equals("");
    }

    public static boolean isTrimNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String emptyForNull(String str) {
        return str == null ? "" : str;
    }

    public static String nullForEmpty(String str) {
        return "".equals(str) ? null : str;
    }

    public static boolean areEqualOrNull(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static String trimQotesIfPresent(String str) {
        if (str == null || str.length() < 2) {
            return str;
        }
        if (str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static void copy(InputStream source, OutputStream destination) throws IOException {
        byte[] buffer = new byte[Short.MAX_VALUE];
        int read = 0;
        while ((read = source.read(buffer)) > 0) {
            destination.write(buffer, 0, read);
        }
    }
}

