/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.serialization.impl;

import com.vmware.cis.license.common.serialization.SerializeException;
import com.vmware.cis.license.common.serialization.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BaseSerializer<T>
implements Serializer<T> {
    private static final int DEFAULT_BUF_SIZE = Short.MAX_VALUE;

    @Override
    public byte[] serializeData(T data) throws SerializeException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(Short.MAX_VALUE);
        try {
            this.serializeData(data, baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new SerializeException("Failed to serialize data", e);
        }
        finally {
            try {
                baos.close();
            }
            catch (Exception e) {}
        }
    }

    public abstract void serializeData(T var1, OutputStream var2) throws SerializeException, IOException;
}

