/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.serialization.impl;

import com.vmware.cis.license.common.serialization.SerializeException;
import com.vmware.cis.license.common.serialization.Serializer;
import com.vmware.cis.license.common.serialization.impl.BaseSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GZipSerializerWrapperImpl<T>
extends BaseSerializer<T>
implements Serializer<T> {
    private final BaseSerializer<T> _serializer;

    public GZipSerializerWrapperImpl(BaseSerializer<T> serializer) {
        this._serializer = serializer;
    }

    @Override
    public void serializeData(T data, OutputStream outputStream) throws SerializeException, IOException {
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
            this._serializer.serializeData(data, gzipOutputStream);
            gzipOutputStream.flush();
            gzipOutputStream.finish();
        }
        catch (IOException e) {
            throw new SerializeException("Failed to compress data", e);
        }
    }
}

