/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.vmodl;

import com.vmware.cis.license.common.misc.Util;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.impl.vmodl.LocalizableMessageImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.binding.vmodl.wsdlName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VmodlUtil {
    public static void addKeyValue(String key, Object value, ArrayList<KeyAnyValue> props) {
        assert (key != null && value != null && props != null);
        KeyAnyValueImpl keyValue = new KeyAnyValueImpl();
        keyValue.setKey(key);
        keyValue.setValue(value);
        props.add((KeyAnyValue)keyValue);
    }

    public static <T> T findFirstValue(String key, KeyAnyValue[] props) {
        assert (key != null);
        Object res = null;
        if (props != null && key != null) {
            for (int i = 0; i < props.length; ++i) {
                if (!key.equals(props[i].getKey())) continue;
                res = props[i].getValue();
                break;
            }
        }
        return (T)res;
    }

    public static <T> T findFirstValue(String key, List<KeyAnyValue> props) {
        assert (key != null);
        Object res = null;
        if (props != null && key != null) {
            for (KeyAnyValue item : props) {
                if (!key.equals(item.getKey())) continue;
                res = item.getValue();
                break;
            }
        }
        return (T)res;
    }

    public static <T> List<T> findAllValues(String key, KeyAnyValue[] props) {
        assert (key != null);
        ArrayList<Object> res = null;
        if (props != null && key != null) {
            for (int i = 0; i < props.length; ++i) {
                if (!key.equals(props[i].getKey())) continue;
                if (res == null) {
                    res = new ArrayList<Object>();
                }
                res.add(props[i].getValue());
            }
        }
        return res;
    }

    public static <T> List<T> findAllValues(String key, List<KeyAnyValue> props) {
        assert (key != null);
        ArrayList<Object> res = null;
        if (props != null && key != null) {
            for (KeyAnyValue item : props) {
                if (!key.equals(item.getKey())) continue;
                if (res == null) {
                    res = new ArrayList<Object>();
                }
                res.add(item.getValue());
            }
        }
        return res;
    }

    public static KeyAnyValue[] mergeKeyValues(List<KeyAnyValue> newProps, KeyAnyValue[] oldProps) {
        assert (newProps != null);
        if (newProps.size() == 0) {
            return oldProps;
        }
        if (oldProps != null) {
            for (int i = 0; i < oldProps.length; ++i) {
                newProps.add(oldProps[i]);
            }
        }
        return newProps.toArray(new KeyAnyValue[newProps.size()]);
    }

    public static KeyAnyValue[] removeKeyValue(String key, KeyAnyValue[] props) {
        assert (key != null);
        ArrayList<KeyAnyValue> res = new ArrayList<KeyAnyValue>();
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                KeyAnyValue prop = props[i];
                if (prop.getKey().equals(key)) continue;
                res.add(prop);
            }
        }
        KeyAnyValue[] resArr = res.toArray(new KeyAnyValue[res.size()]);
        return resArr;
    }

    public static void removeKeyValue(String key, ArrayList<KeyAnyValue> props) {
        assert (key != null);
        if (Util.isNullOrEmpty(props)) {
            return;
        }
        ArrayList<KeyAnyValue> res = new ArrayList<KeyAnyValue>();
        for (int i = 0; i < props.size(); ++i) {
            KeyAnyValue prop = props.get(i);
            if (prop.getKey().equals(key)) continue;
            res.add(prop);
        }
        if (res.size() != props.size()) {
            props.clear();
            props.addAll(res);
        }
    }

    public static List<String> getKeys(List<KeyAnyValue> properties) {
        ArrayList<String> keys = new ArrayList<String>();
        if (properties != null) {
            for (int i = 0; i < properties.size(); ++i) {
                keys.add(properties.get(i).getKey());
            }
        }
        return keys;
    }

    public static String getWsdlTypeName(Class<?> vmodlClass) {
        String typeName = null;
        wsdlName wsdlNameAnnotation = vmodlClass.getAnnotation(wsdlName.class);
        if (wsdlNameAnnotation != null) {
            typeName = wsdlNameAnnotation.value();
        }
        if (Util.isNullOrEmpty(typeName)) {
            typeName = vmodlClass.getSimpleName();
        }
        return typeName;
    }

    public static ArrayList<KeyAnyValue> createExtensibleList(KeyAnyValue[] arr) {
        ArrayList<KeyAnyValue> list = new ArrayList<KeyAnyValue>();
        if (arr != null) {
            list.addAll(Arrays.asList(arr));
        }
        return list;
    }

    public static AssertionError createNoServerSideImplAssertionError() {
        return new AssertionError((Object)"This method should not be used in server vmodl impl.");
    }

    public static void setVmodlFaultMessage(Exception vmodlFault, String message) {
        if (vmodlFault instanceof MethodFault) {
            ((MethodFault)vmodlFault).setMessage(message);
        } else if (vmodlFault instanceof RuntimeFault) {
            ((RuntimeFault)vmodlFault).setMessage(message);
        } else assert (false);
    }

    public static void setVmodlFaultLocalizeMessage(Exception fault, LocalizableMessage localizableMessage) {
        if (localizableMessage != null) {
            if (fault instanceof MethodFault) {
                ((MethodFault)fault).setFaultMessage(new LocalizableMessage[]{localizableMessage});
            } else if (fault instanceof RuntimeFault) {
                ((RuntimeFault)fault).setFaultMessage(new LocalizableMessage[]{localizableMessage});
            }
        }
    }

    public static LocalizableMessage buildLocalizableMessage(String key, String[][] args) {
        LocalizableMessageImpl localizableMessage = new LocalizableMessageImpl();
        localizableMessage.setKey(key);
        ArrayList<KeyAnyValue> messageArgs = new ArrayList<KeyAnyValue>();
        if (!Util.isNullOrEmpty(args)) {
            for (int i = 0; i < args.length; ++i) {
                String argKey = args[i][0];
                String argValue = args[i][1];
                VmodlUtil.addKeyValue(argKey, argValue, messageArgs);
            }
            localizableMessage.setArg(messageArgs.toArray(new KeyAnyValue[messageArgs.size()]));
        }
        return localizableMessage;
    }

    public static String encodeMultiValueForLocalizeMessageArgument(String[] values) {
        StringBuilder result = new StringBuilder();
        if (values != null) {
            for (String value : values) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(value);
            }
        }
        return result.toString();
    }

    public static KeyAnyValue[] replaceOrAddProperty(String key, Object value, KeyAnyValue[] properties) {
        assert (!Util.isNullOrEmpty(key));
        ArrayList<Object> res = new ArrayList<Object>();
        boolean toAdd = true;
        if (!Util.isNullOrEmpty(properties)) {
            for (int i = 0; i < properties.length; ++i) {
                KeyAnyValue property = properties[i];
                if (property.getKey().equals(key)) {
                    property.setValue(value);
                    toAdd = false;
                }
                res.add(property);
            }
        }
        if (toAdd) {
            KeyAnyValueImpl prop = new KeyAnyValueImpl();
            prop.setKey(key);
            prop.setValue(value);
            res.add(prop);
        }
        return res.toArray(new KeyAnyValue[res.size()]);
    }
}

