/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.capacity;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.cluster.ResourceUsageSummary;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.capacity.data.util.CapacityObjectTypeConstants;
import com.vmware.vsphere.client.capacity.data.util.CapacityPropertyConstants;
import com.vmware.vsphere.client.capacity.util.CapacityAggregator;
import com.vmware.vsphere.client.capacity.util.CapacityQueryBuilder;
import com.vmware.vsphere.client.data.util.DataUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CapacityPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final String[] SUPPORTED_OBJECT_TYPES = new String[]{CapacityObjectTypeConstants.DATACENTER, CapacityObjectTypeConstants.CLUSTER, CapacityObjectTypeConstants.HOST_SYSTEM, CapacityObjectTypeConstants.FOLDER};
    private static final int MB_TO_BYTE = 0x100000;
    private static final Log _logger = LogFactory.getLog(CapacityPropertyProviderAdapter.class);
    private final DataService _dataService;

    public CapacityPropertyProviderAdapter(DataServiceExtensionRegistry registry, DataService dataService) {
        this._dataService = dataService;
        registry.registerDataAdapter((PropertyProviderAdapter)this, CapacityPropertyProviderAdapter.getProvidedTypeInfos());
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        _logger.debug((Object)("Requesting capacity related properties: " + Arrays.toString(propertyRequest.properties) + " for " + Arrays.toString(propertyRequest.objects)));
        ArrayList<ManagedObjectReference> postVc6Clusters = new ArrayList<ManagedObjectReference>();
        ArrayList<ManagedObjectReference> allOtherObjects = new ArrayList<ManagedObjectReference>();
        ManagedObjectReference[] moRefs = DataUtil.extractObjectRefs((PropertyRequestSpec)propertyRequest);
        ArrayList<ResultItem> resultSetItems = new ArrayList<ResultItem>();
        for (ManagedObjectReference moRef : moRefs) {
            if (CapacityObjectTypeConstants.CLUSTER.equals(moRef.getType()) && VcServiceUtil.is2014VcOrLater((String)moRef.getServerGuid())) {
                postVc6Clusters.add(moRef);
                continue;
            }
            allOtherObjects.add(moRef);
        }
        if (!postVc6Clusters.isEmpty()) {
            Map<ManagedObjectReference, ResourceUsageSummary> clusterResourceUsageData = this.getClusterResourceUsageData(postVc6Clusters);
            resultSetItems.addAll(CapacityPropertyProviderAdapter.getResults(clusterResourceUsageData, propertyRequest));
        }
        if (!allOtherObjects.isEmpty()) {
            QuerySpec[] querySpecs = CapacityQueryBuilder.buildQueries(allOtherObjects, propertyRequest.properties);
            RequestSpec requestSpec = new RequestSpec();
            requestSpec.querySpec = querySpecs;
            ResultSet[] rawData = this._dataService.getData((RequestSpec)requestSpec).resultSet;
            resultSetItems.addAll(CapacityPropertyProviderAdapter.getResults(allOtherObjects, rawData, propertyRequest));
        }
        if (resultSetItems.isEmpty()) {
            _logger.info((Object)("No results received after an attempt to retrieve " + Arrays.toString(propertyRequest.properties) + " for " + Arrays.toString(propertyRequest.objects)));
            return new ResultSet();
        }
        ResultSet finalResult = new ResultSet();
        finalResult.items = resultSetItems.toArray(new ResultItem[resultSetItems.size()]);
        _logger.debug((Object)"Capacity related properties were successfully collected.");
        return finalResult;
    }

    private Map<ManagedObjectReference, ResourceUsageSummary> getClusterResourceUsageData(List<ManagedObjectReference> moRefs) {
        HashMap<ManagedObjectReference, ResourceUsageSummary> rawClusterData = new HashMap<ManagedObjectReference, ResourceUsageSummary>(moRefs.size());
        for (ManagedObjectReference moRef : moRefs) {
            try {
                ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)moRef);
                ResourceUsageSummary clusterResourceUsage = cluster.getResourceUsage();
                rawClusterData.put(moRef, clusterResourceUsage);
            }
            catch (Exception e) {
                _logger.error((Object)("Unable to retrieve ClusterComputeResource for " + moRef), (Throwable)e);
            }
        }
        return rawClusterData;
    }

    private static TypeInfo[] getProvidedTypeInfos() {
        LinkedList<TypeInfo> typeInfos = new LinkedList<TypeInfo>();
        for (String objectType : SUPPORTED_OBJECT_TYPES) {
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.type = objectType;
            typeInfo.properties = CapacityPropertyConstants.SUPPORTED_PROPERTIES;
            typeInfos.add(typeInfo);
        }
        return typeInfos.toArray(new TypeInfo[typeInfos.size()]);
    }

    private static List<ResultItem> getResults(List<ManagedObjectReference> targetObjects, ResultSet[] rawResultSets, PropertyRequestSpec propertyRequest) {
        LinkedList<ResultItem> aggregatedItems = new LinkedList<ResultItem>();
        for (ResultSet rawData : rawResultSets) {
            ManagedObjectReference targetObjectRef = CapacityPropertyProviderAdapter.findRefByQueryName(rawData, targetObjects);
            ResultItem resultItem = CapacityPropertyProviderAdapter.getZeroedResultItem(propertyRequest, targetObjectRef);
            CapacityAggregator.aggregateData(rawData, resultItem);
            aggregatedItems.add(resultItem);
        }
        return aggregatedItems;
    }

    private static List<ResultItem> getResults(Map<ManagedObjectReference, ResourceUsageSummary> clusterUsagesMap, PropertyRequestSpec propertyRequest) {
        ArrayList<ResultItem> clustersData = new ArrayList<ResultItem>(clusterUsagesMap.size());
        for (ManagedObjectReference clusterRef : clusterUsagesMap.keySet()) {
            ResourceUsageSummary clusterData = clusterUsagesMap.get(clusterRef);
            ResultItem resultItem = CapacityPropertyProviderAdapter.getZeroedResultItem(propertyRequest, clusterRef);
            for (PropertyValue property : resultItem.properties) {
                if ("totalCpuCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getCpuCapacityMHz();
                    continue;
                }
                if ("usedCpuCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getCpuUsedMHz();
                    continue;
                }
                if ("freeCpuCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getCpuCapacityMHz() - clusterData.getCpuUsedMHz();
                    continue;
                }
                if ("totalMemoryCapacity".equals(property.propertyName)) {
                    long memCapacityMB = clusterData.getMemCapacityMB();
                    property.value = memCapacityMB * 0x100000L;
                    continue;
                }
                if ("usedMemoryCapacity".equals(property.propertyName)) {
                    long memUsedMB = clusterData.getMemUsedMB();
                    property.value = memUsedMB * 0x100000L;
                    continue;
                }
                if ("freeMemoryCapacity".equals(property.propertyName)) {
                    long memFreeMB = clusterData.getMemCapacityMB() - clusterData.getMemUsedMB();
                    property.value = memFreeMB * 0x100000L;
                    continue;
                }
                if ("totalStorageCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getStorageCapacityMB() * 0x100000L;
                    continue;
                }
                if ("usedStorageCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getStorageUsedMB() * 0x100000L;
                    continue;
                }
                if (!"freeStorageCapacity".equals(property.propertyName)) continue;
                long storageFreeMB = clusterData.getStorageCapacityMB() - clusterData.getStorageUsedMB();
                property.value = storageFreeMB * 0x100000L;
            }
            clustersData.add(resultItem);
        }
        return clustersData;
    }

    private static ManagedObjectReference findRefByQueryName(ResultSet resultSet, List<ManagedObjectReference> targetObjects) {
        String queryName = resultSet.queryName;
        if (StringUtil.isNullOrEmpty((String)queryName)) {
            _logger.warn((Object)"Query without a name!");
            return null;
        }
        int separatorIndex = queryName.indexOf(":");
        String refId = queryName.substring(separatorIndex + 1);
        if (StringUtil.isNullOrEmpty((String)refId)) {
            _logger.warn((Object)("Query name without a moRef Id specified - " + queryName));
            return null;
        }
        for (ManagedObjectReference targetObject : targetObjects) {
            if (!refId.equals(targetObject.toString())) continue;
            return targetObject;
        }
        _logger.warn((Object)("Query's moRef was not found - " + queryName));
        return null;
    }

    private static ResultItem getZeroedResultItem(PropertyRequestSpec propertyRequest, ManagedObjectReference moRef) {
        String[] requestedProps = DataUtil.extractSupportedProperties((PropertySpec[])propertyRequest.properties, (String[])CapacityPropertyConstants.SUPPORTED_PROPERTIES, (ManagedObjectReference)moRef);
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = moRef;
        resultItem.properties = new PropertyValue[requestedProps.length];
        for (int i = 0; i < requestedProps.length; ++i) {
            String requestedPropName = requestedProps[i];
            PropertyValue propVal = new PropertyValue();
            propVal.propertyName = requestedPropName;
            propVal.value = 0L;
            resultItem.properties[i] = propVal;
        }
        return resultItem;
    }
}

