/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.authn.impl;

import com.vmware.license.myvmware.client.MyVMwareClientException;
import com.vmware.license.myvmware.client.authn.AuthenticationConfig;
import com.vmware.license.myvmware.client.authn.AuthenticationHttpConfig;
import com.vmware.license.myvmware.client.authn.AuthenticationToken;
import com.vmware.license.myvmware.client.authn.AuthenticationTokenFactory;
import com.vmware.license.myvmware.client.authn.impl.rest.GenerateTokenResponse;
import com.vmware.license.myvmware.client.rest.MyVMwareRestServiceHelper;
import com.vmware.license.myvmware.client.rest.MyVMwareRestServiceUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;

public class AuthenticationTokenFactoryImpl
implements AuthenticationTokenFactory {
    private final AuthenticationConfig _authenticationConfig;
    private final AuthenticationHttpConfig _httpConfig;
    private final MyVMwareRestServiceHelper _myVMwareRestServiceHelper;

    public AuthenticationTokenFactoryImpl() {
        this(AuthenticationConfig.createDefaultAuthenticationConfig());
    }

    public AuthenticationTokenFactoryImpl(AuthenticationConfig authenticationConfig) {
        this(authenticationConfig, AuthenticationHttpConfig.createDefaultHttpConfig());
    }

    public AuthenticationTokenFactoryImpl(AuthenticationConfig authenticationConfig, AuthenticationHttpConfig httpConfig) {
        this._authenticationConfig = authenticationConfig;
        this._httpConfig = httpConfig;
        this._myVMwareRestServiceHelper = new MyVMwareRestServiceHelper(httpConfig.getConnectTimeoutInMs());
    }

    @Override
    public AuthenticationToken createToken(String username, String password) throws MyVMwareClientException, TimeoutException {
        HashMap<String, String> requestHttpHeadersMap = new HashMap<String, String>();
        MyVMwareRestServiceUtil.populateHttpHeadersWithBasicAuth(requestHttpHeadersMap, this._authenticationConfig.getClientId(), this._authenticationConfig.getClientSecret());
        String generateTokenRequest = this.createGenerateTokenRequest(username, password);
        GenerateTokenResponse generateTokenResponse = this._myVMwareRestServiceHelper.executePostRequest(this._authenticationConfig.getStsUri().toString(), this._httpConfig.getTimeoutAcquireTokenInMs(), generateTokenRequest, requestHttpHeadersMap, GenerateTokenResponse.class, new Object[0]);
        String authToken = generateTokenResponse.getAccess_token();
        long tokenExpirationInMs = System.currentTimeMillis() + generateTokenResponse.getExpires_in() * 1000L;
        return new AuthenticationToken(authToken, new Date(tokenExpirationInMs));
    }

    private String createGenerateTokenRequest(String userName, String password) {
        return "username=" + userName + "&password=" + password;
    }
}

