/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.entitlementreport.impl;

import com.vmware.cis.license.common.misc.DateUtil;
import com.vmware.cis.license.common.misc.Util;
import com.vmware.license.myvmware.client.MyVMwareClientException;
import com.vmware.license.myvmware.client.authn.AuthenticationToken;
import com.vmware.license.myvmware.client.entitlementreport.EntitlementAccount;
import com.vmware.license.myvmware.client.entitlementreport.EntitlementReport;
import com.vmware.license.myvmware.client.entitlementreport.EntitlementReportGenerationSpec;
import com.vmware.license.myvmware.client.entitlementreport.Folder;
import com.vmware.license.myvmware.client.entitlementreport.MyVMwareEntitlementReportClient;
import com.vmware.license.myvmware.client.entitlementreport.MyVMwareEntitlementReportClientHttpConfig;
import com.vmware.license.myvmware.client.entitlementreport.RootFolder;
import com.vmware.license.myvmware.client.entitlementreport.impl.rest.GenerateReportRequest;
import com.vmware.license.myvmware.client.entitlementreport.impl.rest.GenerateReportResponse;
import com.vmware.license.myvmware.client.entitlementreport.impl.rest.GetEntitlementAccountsFoldersResponse;
import com.vmware.license.myvmware.client.entitlementreport.impl.rest.GetEntitlementAccountsResponse;
import com.vmware.license.myvmware.client.entitlementreport.impl.rest.GetReportGenerationStatusResponse;
import com.vmware.license.myvmware.client.rest.MyVMwareRestServiceHelper;
import com.vmware.license.myvmware.client.rest.MyVMwareRestServiceUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;

public class MyVMwareEntitlementReportClientImpl
implements MyVMwareEntitlementReportClient {
    private static final String REPORT_GENERATION_STATUS_IN_PROGRESS = "IN-PROGRESS";
    private static final String REPORT_GENERATION_STATUS_COMPLETED = "COMPLETED";
    private final MyVMwareEntitlementReportClientHttpConfig _httpConfig;
    private final URI _baseUri;
    private final MyVMwareRestServiceHelper _myVMwareRestServiceHelper;

    public MyVMwareEntitlementReportClientImpl(MyVMwareEntitlementReportClientHttpConfig httpConfig, URI baseUri, AuthenticationToken authenticationToken) {
        this._httpConfig = httpConfig;
        this._baseUri = baseUri;
        HashMap<String, String> httpRequestHeadersMap = new HashMap<String, String>();
        MyVMwareRestServiceUtil.populateHttpHeadersWithBearerToken(httpRequestHeadersMap, authenticationToken.getTokenValue());
        this._myVMwareRestServiceHelper = new MyVMwareRestServiceHelper(httpRequestHeadersMap, httpConfig.getConnectTimeoutInMs());
    }

    @Override
    public EntitlementAccount[] getEntitlementAccounts() throws MyVMwareClientException, TimeoutException {
        GetEntitlementAccountsResponse getAccountsResponse = this._myVMwareRestServiceHelper.executeGetRequest(this.getAccountsUrl(), this._httpConfig.getTimeoutGetEntitlementAccountsInMs(), GetEntitlementAccountsResponse.class, new Object[0]);
        return MyVMwareEntitlementReportClientImpl.buildEntitlementAccounts(getAccountsResponse.getEntitlementAccounts());
    }

    @Override
    public RootFolder getEntitlementAccountFolders(String eaNumber) throws MyVMwareClientException, TimeoutException {
        if (Util.isNullOrEmpty((String)eaNumber)) {
            throw new IllegalArgumentException("Invalid parameter: eaNumber cannot be null or empty");
        }
        GetEntitlementAccountsFoldersResponse getFoldersResponse = this._myVMwareRestServiceHelper.executeGetRequest(this.getFoldersUrl(), this._httpConfig.getTimeoutGetEntitlementAccountsFoldersInMs(), GetEntitlementAccountsFoldersResponse.class, eaNumber);
        return MyVMwareEntitlementReportClientImpl.buildRootFolder(getFoldersResponse.getRoot(), eaNumber);
    }

    @Override
    public String initiateEntitlementReportGeneration(EntitlementReportGenerationSpec entitlementReportGenerationSpec) throws MyVMwareClientException, TimeoutException {
        MyVMwareEntitlementReportClientImpl.validateEntitlementReportGenerationSpec(entitlementReportGenerationSpec);
        GenerateReportRequest reportGenerationRequest = MyVMwareEntitlementReportClientImpl.buildReportGenerationRequest(entitlementReportGenerationSpec);
        GenerateReportResponse reportGenerationResponse = this._myVMwareRestServiceHelper.executePostRequest(this.getReportGenerationUrl(), this._httpConfig.getTimeoutGenerateEntitlementReportInMs(), reportGenerationRequest, GenerateReportResponse.class, new Object[0]);
        return reportGenerationResponse.getReportJobId();
    }

    @Override
    public boolean isEntitlementReportGenerationComplete(String reportGenerationJobId) throws MyVMwareClientException, TimeoutException {
        if (Util.isNullOrEmpty((String)reportGenerationJobId)) {
            throw new IllegalArgumentException("Invalid parameter: reportGenerationJobId cannot be null or empty");
        }
        GetReportGenerationStatusResponse reportGenerationStatusResponse = this._myVMwareRestServiceHelper.executeGetRequest(this.getReportGenerationStatusUrl(), this._httpConfig.getTimeoutGetEntitlementReportStatusInMs(), GetReportGenerationStatusResponse.class, reportGenerationJobId);
        String jobStatus = reportGenerationStatusResponse.getJobStatus();
        boolean isEntitlementReportGenerationComplete = false;
        if (REPORT_GENERATION_STATUS_COMPLETED.equalsIgnoreCase(jobStatus)) {
            isEntitlementReportGenerationComplete = true;
        } else if (!REPORT_GENERATION_STATUS_IN_PROGRESS.equalsIgnoreCase(jobStatus)) {
            throw new MyVMwareClientException(String.format("Error generating MyVMware entitlement report. Job id: %s, job status: %s.", reportGenerationJobId, jobStatus));
        }
        return isEntitlementReportGenerationComplete;
    }

    @Override
    public EntitlementReport getEntitlementReport(String reportGenerationJobId) throws MyVMwareClientException, TimeoutException {
        if (Util.isNullOrEmpty((String)reportGenerationJobId)) {
            throw new IllegalArgumentException("Invalid parameter: reportGenerationJobId cannot be null or empty");
        }
        byte[] reportData = this._myVMwareRestServiceHelper.executeGetRequest(this.getReportDownloadUrl(), this._httpConfig.getTimeoutGetEntitlementReportInMs(), byte[].class, reportGenerationJobId);
        return new EntitlementReport(reportData);
    }

    @Override
    public void close() {
    }

    private String getAccountsUrl() {
        return this._baseUri.toString() + "/accounts";
    }

    private String getFoldersUrl() {
        return this._baseUri.toString() + "/accounts/{ea_number}/folders";
    }

    private String getReportGenerationUrl() {
        return this._baseUri.toString() + "/product-license-details-history";
    }

    private String getReportGenerationStatusUrl() {
        return this._baseUri.toString() + "/{report_job_id}";
    }

    private String getReportDownloadUrl() {
        return this._baseUri.toString() + "/file/download/{report_job_id}";
    }

    private static void validateEntitlementReportGenerationSpec(EntitlementReportGenerationSpec entitlementReportGenerationSpec) {
        if (entitlementReportGenerationSpec == null) {
            throw new IllegalArgumentException("Invalid parameter: entitlementReportGenerationSpec cannot be null");
        }
        MyVMwareEntitlementReportClientImpl.validateEntitlementReportAccountFolderSpecs(entitlementReportGenerationSpec.getEntitlementReportAccountFolderSpecs());
    }

    private static void validateEntitlementReportAccountFolderSpecs(EntitlementReportGenerationSpec.EntitlementReportAccountFolderSpec[] entitlementReportAccountFolderSpecs) {
        if (Util.isNullOrEmpty((Object[])entitlementReportAccountFolderSpecs)) {
            return;
        }
        for (EntitlementReportGenerationSpec.EntitlementReportAccountFolderSpec entitlementReportAccountFolderSpec : entitlementReportAccountFolderSpecs) {
            if (entitlementReportAccountFolderSpec == null) {
                throw new IllegalArgumentException("Invalid entitlement report accountFolder spec: entitlementReportAccountFolderSpec cannot be null");
            }
            if (Util.isNullOrEmpty((String)entitlementReportAccountFolderSpec.getEaNumber())) {
                throw new IllegalArgumentException("Invalid entitlement report accountFolder spec: eaNumber cannot be null or empty");
            }
            if (Util.isNullOrEmpty((Object[])entitlementReportAccountFolderSpec.getFolderIds())) continue;
            for (String folderId : entitlementReportAccountFolderSpec.getFolderIds()) {
                if (!Util.isNullOrEmpty((String)folderId)) continue;
                throw new IllegalArgumentException("Invalid entitlement report accountFolder spec: folderId cannot be null or empty");
            }
        }
    }

    private static EntitlementAccount[] buildEntitlementAccounts(GetEntitlementAccountsResponse.EntitlementAccount[] accounts) {
        if (Util.isNullOrEmpty((Object[])accounts)) {
            return new EntitlementAccount[0];
        }
        ArrayList<EntitlementAccount> result = new ArrayList<EntitlementAccount>();
        for (GetEntitlementAccountsResponse.EntitlementAccount account : accounts) {
            result.add(new EntitlementAccount(account.getEaNumber(), account.getEaName(), account.getSuperUserName()));
        }
        return result.toArray(new EntitlementAccount[result.size()]);
    }

    private static RootFolder buildRootFolder(GetEntitlementAccountsFoldersResponse.RootFolder rootFolder, String eaNumber) {
        if (rootFolder == null) {
            return null;
        }
        ArrayList<Folder> subFolders = new ArrayList<Folder>();
        if (!Util.isNullOrEmpty((Object[])rootFolder.getSubfolders())) {
            for (GetEntitlementAccountsFoldersResponse.Folder subFolder : rootFolder.getSubfolders()) {
                if (subFolder == null) continue;
                subFolders.add(new Folder(subFolder.getId(), subFolder.getName(), subFolder.getSubfolderCount()));
            }
        }
        return new RootFolder(rootFolder.getId(), rootFolder.getName(), subFolders.toArray(new Folder[subFolders.size()]), eaNumber);
    }

    private static GenerateReportRequest buildReportGenerationRequest(EntitlementReportGenerationSpec entitlementReportGenerationSpec) {
        GenerateReportRequest reportGenerationRequest = new GenerateReportRequest();
        ArrayList<GenerateReportRequest.AccountFolderSpec> accountFolderSpecs = new ArrayList<GenerateReportRequest.AccountFolderSpec>();
        if (!Util.isNullOrEmpty((Object[])entitlementReportGenerationSpec.getEntitlementReportAccountFolderSpecs())) {
            for (EntitlementReportGenerationSpec.EntitlementReportAccountFolderSpec entitlementReportAccountFolderSpec : entitlementReportGenerationSpec.getEntitlementReportAccountFolderSpecs()) {
                GenerateReportRequest.AccountFolderSpec accountFolderSpec = new GenerateReportRequest.AccountFolderSpec();
                accountFolderSpec.setEaNumber(entitlementReportAccountFolderSpec.getEaNumber());
                accountFolderSpec.setFolderIds(entitlementReportAccountFolderSpec.getFolderIds());
                accountFolderSpecs.add(accountFolderSpec);
            }
        }
        reportGenerationRequest.setAccounts(accountFolderSpecs.toArray(new GenerateReportRequest.AccountFolderSpec[accountFolderSpecs.size()]));
        reportGenerationRequest.setFromDate(MyVMwareEntitlementReportClientImpl.formatDateOrReturnNull(entitlementReportGenerationSpec.getFromDate()));
        reportGenerationRequest.setToDate(MyVMwareEntitlementReportClientImpl.formatDateOrReturnNull(entitlementReportGenerationSpec.getToDate()));
        return reportGenerationRequest;
    }

    private static String formatDateOrReturnNull(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtil.formatISODateShort((Date)date);
    }
}

