/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.rest;

import com.vmware.cis.license.common.misc.Util;
import com.vmware.license.myvmware.client.MyVMwareClientException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class MyVMwareRestServiceHelper {
    private static final int DEFAULT_READ_TIMEOUT_IN_MS = 300000;
    private final RestTemplate _restTemplate;
    private Map<String, String> _httpRequestHeadersMap;
    private final int _connectTimeoutInMs;

    public MyVMwareRestServiceHelper(int connectTimeoutInMs) {
        this(null, connectTimeoutInMs);
    }

    public MyVMwareRestServiceHelper(Map<String, String> httpRequestHeadersMap, int connectTimeoutInMs) {
        this._httpRequestHeadersMap = httpRequestHeadersMap;
        SimpleClientHttpRequestFactory httpRequestFactory = new SimpleClientHttpRequestFactory();
        httpRequestFactory.setReadTimeout(300000);
        this._connectTimeoutInMs = connectTimeoutInMs;
        httpRequestFactory.setConnectTimeout(this._connectTimeoutInMs);
        this._restTemplate = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
    }

    public <R> R executeGetRequest(String url, int readTimeoutInMs, Class<R> responseType, Object ... uriVariables) throws MyVMwareClientException, TimeoutException {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.createHttpRequestHeaders(null));
        return this.executeRequest(url, readTimeoutInMs, HttpMethod.GET, requestEntity, responseType, uriVariables);
    }

    public <B, R> R executePostRequest(String url, int readTimeoutInMs, B requestBody, Class<R> responseType, Object ... uriVariables) throws MyVMwareClientException, TimeoutException {
        return this.executePostRequest(url, readTimeoutInMs, requestBody, null, responseType, uriVariables);
    }

    public <B, R> R executePostRequest(String url, int readTimeoutInMs, B requestBody, Map<String, String> httpRequestHeadersMap, Class<R> responseType, Object ... uriVariables) throws MyVMwareClientException, TimeoutException {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)this.createHttpRequestHeaders(httpRequestHeadersMap));
        return this.executeRequest(url, readTimeoutInMs, HttpMethod.POST, requestEntity, responseType, uriVariables);
    }

    private <B, R> R executeRequest(String url, int readTimeoutInMs, HttpMethod httpMethod, HttpEntity<B> requestEntity, Class<R> responseType, Object ... uriVariables) throws MyVMwareClientException, TimeoutException {
        try {
            this.setReadTimeout(readTimeoutInMs);
            ResponseEntity responseEntity = this._restTemplate.exchange(url, httpMethod, requestEntity, responseType, uriVariables);
            Object object = responseEntity.getBody();
            return (R)object;
        }
        catch (HttpStatusCodeException e) {
            throw new MyVMwareClientException(String.format("Error executing %s request for %s, received http status code %s. Status text: %s.", httpMethod.toString(), url, e.getStatusCode(), e.getStatusText()), e, MyVMwareRestServiceHelper.convertStatusCodeToReasonType(e.getStatusCode()));
        }
        catch (RestClientException e) {
            if (MyVMwareRestServiceHelper.isSocketTimeoutExceptionCause(e)) {
                throw new TimeoutException(String.format("%s operation for %s took longer than %d milliseconds.", httpMethod.toString(), url, readTimeoutInMs));
            }
            if (MyVMwareRestServiceHelper.isConnectExceptionCause(e)) {
                throw new TimeoutException(String.format("Timeout occured while trying to establish connection to %s after %s miliseconds.", url, this._connectTimeoutInMs));
            }
            throw new MyVMwareClientException(String.format("Error executing post request for %s. Reason: %s.", url, e.getMessage()), e);
        }
        finally {
            this.setReadTimeout(300000);
        }
    }

    private HttpHeaders createHttpRequestHeaders(Map<String, String> httpRequestHeadersMap) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        this.populateHttpRequestHeaders(httpHeaders, this._httpRequestHeadersMap);
        this.populateHttpRequestHeaders(httpHeaders, httpRequestHeadersMap);
        return httpHeaders;
    }

    private void populateHttpRequestHeaders(HttpHeaders httpHeaders, Map<String, String> httpRequestHeadersMap) {
        if (Util.isNullOrEmpty(httpRequestHeadersMap)) {
            return;
        }
        for (Map.Entry<String, String> entry : httpRequestHeadersMap.entrySet()) {
            httpHeaders.set(entry.getKey(), entry.getValue());
        }
    }

    private void setReadTimeout(int readTimeoutInMs) {
        SimpleClientHttpRequestFactory httpRequestFactory = (SimpleClientHttpRequestFactory)this._restTemplate.getRequestFactory();
        httpRequestFactory.setReadTimeout(readTimeoutInMs);
    }

    private static MyVMwareClientException.ReasonType convertStatusCodeToReasonType(HttpStatus status) {
        if (HttpStatus.UNAUTHORIZED.equals((Object)status)) {
            return MyVMwareClientException.ReasonType.ACCESS_UNAUTHORIZED;
        }
        if (HttpStatus.FORBIDDEN.equals((Object)status)) {
            return MyVMwareClientException.ReasonType.ACCESS_FORBIDDEN;
        }
        if (HttpStatus.NOT_FOUND.equals((Object)status)) {
            return MyVMwareClientException.ReasonType.RESOURCE_NOT_FOUND;
        }
        return MyVMwareClientException.ReasonType.OTHER;
    }

    private static boolean isSocketTimeoutExceptionCause(RestClientException e) {
        return e.getCause() != null && e.getCause() instanceof SocketTimeoutException;
    }

    private static boolean isConnectExceptionCause(RestClientException e) {
        return e.getCause() != null && e.getCause() instanceof ConnectException;
    }
}

