/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.sync.internal.impl;

import com.vmware.cis.license.common.serialization.DeserializeException;
import com.vmware.cis.license.common.serialization.Deserializer;
import com.vmware.cis.license.common.serialization.impl.BaseDeserializer;
import com.vmware.license.myvmware.client.sync.internal.AccountDetails;
import com.vmware.license.myvmware.client.sync.internal.ContractDetails;
import com.vmware.license.myvmware.client.sync.internal.LicenseKeyDetails;
import com.vmware.license.myvmware.client.sync.internal.OrderDetails;
import com.vmware.license.myvmware.client.sync.internal.impl.JsonLicenseKeyDetailsConstants;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonLicenseKeyDetailsDeserializerImpl
extends BaseDeserializer<LicenseKeyDetails>
implements Deserializer<LicenseKeyDetails> {
    public LicenseKeyDetails deserializeData(InputStream inputStream) throws DeserializeException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonLicenseKeyDetailsDeserializerImpl.configureObjectMapper(objectMapper);
        try {
            return JsonLicenseKeyDetailsDeserializerImpl.deserializeLicenseKeyDetails(objectMapper, inputStream);
        }
        catch (IOException e) {
            throw new DeserializeException.CorruptedDataException("Failed to deserialize json data", (Throwable)e);
        }
    }

    private static void configureObjectMapper(ObjectMapper objectMapper) {
        objectMapper.getJsonFactory().disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
    }

    private static LicenseKeyDetails deserializeLicenseKeyDetails(ObjectMapper objectMapper, InputStream inputStream) throws JsonParseException, JsonMappingException, IOException {
        ArrayList licenseKeyDetailsProps = (ArrayList)objectMapper.readValue(inputStream, ArrayList.class);
        LicenseKeyDetails licenseKeyDetails = new LicenseKeyDetails();
        JsonLicenseKeyDetailsDeserializerImpl.populateBaseLicenseKeyDetails(licenseKeyDetails, licenseKeyDetailsProps);
        JsonLicenseKeyDetailsDeserializerImpl.populateCustomLabels(licenseKeyDetails, licenseKeyDetailsProps);
        JsonLicenseKeyDetailsDeserializerImpl.populateOrderDetails(licenseKeyDetails, licenseKeyDetailsProps);
        JsonLicenseKeyDetailsDeserializerImpl.populateContractDetails(licenseKeyDetails, licenseKeyDetailsProps);
        return licenseKeyDetails;
    }

    private static void populateBaseLicenseKeyDetails(LicenseKeyDetails licenseKeyDetails, ArrayList<Object> licenseKeyDetailsProps) {
        AccountDetails accountDetails = new AccountDetails();
        accountDetails.accountNumber = (String)licenseKeyDetailsProps.get(JsonLicenseKeyDetailsConstants.ACCOUNT_NUMBER_IDX);
        accountDetails.accountName = (String)licenseKeyDetailsProps.get(JsonLicenseKeyDetailsConstants.ACCOUNT_NAME_IDX);
        licenseKeyDetails.accountDetails = accountDetails;
        licenseKeyDetails.productName = (String)licenseKeyDetailsProps.get(JsonLicenseKeyDetailsConstants.PRODUCT_NAME_IDX);
        licenseKeyDetails.licenseKey = (String)licenseKeyDetailsProps.get(JsonLicenseKeyDetailsConstants.LICENSE_KEY_IDX);
        String licenseQuantityAsString = (String)licenseKeyDetailsProps.get(JsonLicenseKeyDetailsConstants.LICENSE_QUANTITY_IDX);
        licenseKeyDetails.licenseQuantity = Long.parseLong(licenseQuantityAsString);
        licenseKeyDetails.unitOfMeasure = (String)licenseKeyDetailsProps.get(JsonLicenseKeyDetailsConstants.UNIT_OF_MEASURE_IDX);
        licenseKeyDetails.folderLocation = (String)licenseKeyDetailsProps.get(JsonLicenseKeyDetailsConstants.FOLDER_LOCATION_IDX);
        licenseKeyDetails.licenseKeyNotes = (String)licenseKeyDetailsProps.get(JsonLicenseKeyDetailsConstants.LICENSE_KEY_NOTES_IDX);
    }

    private static void populateCustomLabels(LicenseKeyDetails licenseKeyDetails, ArrayList<Object> licenseKeyDetailsProps) {
        ArrayList<KeyAnyValueImpl> customLabels = new ArrayList<KeyAnyValueImpl>();
        LinkedHashMap customLabelsMap = (LinkedHashMap)licenseKeyDetailsProps.get(JsonLicenseKeyDetailsConstants.CUSTOM_LABELS_IDX);
        for (Map.Entry entry : customLabelsMap.entrySet()) {
            KeyAnyValueImpl customLabel = new KeyAnyValueImpl();
            customLabel.setKey((String)entry.getKey());
            customLabel.setValue(entry.getValue());
            customLabels.add(customLabel);
        }
        licenseKeyDetails.customLabels = customLabels.toArray(new KeyAnyValue[customLabels.size()]);
    }

    private static void populateOrderDetails(LicenseKeyDetails licenseKeyDetails, ArrayList<Object> licenseKeyDetailsProps) {
        ArrayList<OrderDetails> ordersDetails = new ArrayList<OrderDetails>();
        ArrayList orderDetailsList = (ArrayList)licenseKeyDetailsProps.get(JsonLicenseKeyDetailsConstants.ORDER_DETAILS_IDX);
        for (Object orderDetailsObj : orderDetailsList) {
            ArrayList orderElementsList = (ArrayList)orderDetailsObj;
            OrderDetails orderDetails = new OrderDetails();
            orderDetails.type = (String)orderElementsList.get(JsonLicenseKeyDetailsConstants.ORDER_TYPE_IDX);
            orderDetails.number = (String)orderElementsList.get(JsonLicenseKeyDetailsConstants.ORDER_NUMBER_IDX);
            orderDetails.orderQuantity = Long.parseLong((String)orderElementsList.get(JsonLicenseKeyDetailsConstants.ORDER_QUANTITY_IDX));
            Long orderDateInMs = (Long)orderElementsList.get(JsonLicenseKeyDetailsConstants.ORDER_DATE_IDX);
            orderDetails.orderDate = JsonLicenseKeyDetailsDeserializerImpl.convertTimestampToDate(orderDateInMs);
            orderDetails.poNumber = (String)orderElementsList.get(JsonLicenseKeyDetailsConstants.ORDER_PO_NUMBER_IDX);
            ordersDetails.add(orderDetails);
        }
        licenseKeyDetails.orderDetails = ordersDetails.toArray(new OrderDetails[ordersDetails.size()]);
    }

    private static void populateContractDetails(LicenseKeyDetails licenseKeyDetails, ArrayList<Object> licenseKeyDetailsProps) {
        ArrayList<ContractDetails> contractsDetails = new ArrayList<ContractDetails>();
        ArrayList contractDetailsList = (ArrayList)licenseKeyDetailsProps.get(JsonLicenseKeyDetailsConstants.CONTRACT_DETAILS_IDX);
        for (Object contractDetailsObj : contractDetailsList) {
            ArrayList contractElementsList = (ArrayList)contractDetailsObj;
            ContractDetails contractDetails = new ContractDetails();
            contractDetails.type = (String)contractElementsList.get(JsonLicenseKeyDetailsConstants.CONTRACT_TYPE_IDX);
            contractDetails.number = (String)contractElementsList.get(JsonLicenseKeyDetailsConstants.CONTRACT_NUMBER_IDX);
            Long licenseCoverageStartDateInMs = (Long)contractElementsList.get(JsonLicenseKeyDetailsConstants.CONTRACT_LICENSE_COVERAGE_START_DATE_IDX);
            contractDetails.licenseCoverageStartDate = JsonLicenseKeyDetailsDeserializerImpl.convertTimestampToDate(licenseCoverageStartDateInMs);
            Long licenseCoverageEndDateInMs = (Long)contractElementsList.get(JsonLicenseKeyDetailsConstants.CONTRACT_LICENSE_COVERAGE_END_DATE_IDX);
            contractDetails.licenseCoverageEndDate = JsonLicenseKeyDetailsDeserializerImpl.convertTimestampToDate(licenseCoverageEndDateInMs);
            contractDetails.supportLevel = (String)contractElementsList.get(JsonLicenseKeyDetailsConstants.CONTRACT_SUPPORT_LEVEL_IDX);
            contractDetails.ELAFlag = (String)contractElementsList.get(JsonLicenseKeyDetailsConstants.CONTRACT_ELA_FLAG_IDX);
            contractsDetails.add(contractDetails);
        }
        licenseKeyDetails.contractDetails = contractsDetails.toArray(new ContractDetails[contractsDetails.size()]);
    }

    private static Date convertTimestampToDate(Long timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(timestamp);
    }
}

