/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.sync.internal.impl;

import com.vmware.cis.license.common.serialization.SerializeException;
import com.vmware.cis.license.common.serialization.Serializer;
import com.vmware.cis.license.common.serialization.impl.BaseSerializer;
import com.vmware.license.myvmware.client.sync.internal.ContractDetails;
import com.vmware.license.myvmware.client.sync.internal.LicenseKeyDetails;
import com.vmware.license.myvmware.client.sync.internal.OrderDetails;
import com.vmware.license.myvmware.client.sync.internal.impl.JsonLicenseKeyDetailsConstants;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class JsonLicenseKeyDetailsSerializerImpl
extends BaseSerializer<LicenseKeyDetails>
implements Serializer<LicenseKeyDetails> {
    public void serializeData(LicenseKeyDetails licenseKeyDetails, OutputStream outputStream) throws SerializeException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonLicenseKeyDetailsSerializerImpl.configureObjectMapper(objectMapper);
        Object mergedData = JsonLicenseKeyDetailsSerializerImpl.mergeData(licenseKeyDetails);
        try {
            objectMapper.writeValue(outputStream, mergedData);
        }
        catch (IOException e) {
            throw new SerializeException("Failed to serialize data in json format", (Throwable)e);
        }
    }

    private static void configureObjectMapper(ObjectMapper objectMapper) {
        objectMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, false);
        objectMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, true);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.ALWAYS);
        objectMapper.getJsonFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }

    private static Object mergeData(LicenseKeyDetails licenseKeyDetails) {
        ArrayList<Object> licenseKeyDetailsProps = new ArrayList<Object>();
        JsonLicenseKeyDetailsSerializerImpl.populateBaseLicenseKeyDetails(licenseKeyDetailsProps, licenseKeyDetails);
        JsonLicenseKeyDetailsSerializerImpl.populateCustomLabels(licenseKeyDetailsProps, licenseKeyDetails.customLabels);
        JsonLicenseKeyDetailsSerializerImpl.populateOrderDetails(licenseKeyDetailsProps, licenseKeyDetails.orderDetails);
        JsonLicenseKeyDetailsSerializerImpl.populateContractDetails(licenseKeyDetailsProps, licenseKeyDetails.contractDetails);
        return licenseKeyDetailsProps;
    }

    private static void populateBaseLicenseKeyDetails(ArrayList<Object> licenseKeyDetailsProps, LicenseKeyDetails licenseKeyDetails) {
        licenseKeyDetailsProps.add(JsonLicenseKeyDetailsConstants.ACCOUNT_NUMBER_IDX, licenseKeyDetails.accountDetails.accountNumber);
        licenseKeyDetailsProps.add(JsonLicenseKeyDetailsConstants.ACCOUNT_NAME_IDX, licenseKeyDetails.accountDetails.accountName);
        licenseKeyDetailsProps.add(JsonLicenseKeyDetailsConstants.PRODUCT_NAME_IDX, licenseKeyDetails.productName);
        licenseKeyDetailsProps.add(JsonLicenseKeyDetailsConstants.LICENSE_KEY_IDX, licenseKeyDetails.licenseKey);
        licenseKeyDetailsProps.add(JsonLicenseKeyDetailsConstants.LICENSE_QUANTITY_IDX, String.valueOf(licenseKeyDetails.licenseQuantity));
        licenseKeyDetailsProps.add(JsonLicenseKeyDetailsConstants.UNIT_OF_MEASURE_IDX, licenseKeyDetails.unitOfMeasure);
        licenseKeyDetailsProps.add(JsonLicenseKeyDetailsConstants.FOLDER_LOCATION_IDX, licenseKeyDetails.folderLocation);
        licenseKeyDetailsProps.add(JsonLicenseKeyDetailsConstants.LICENSE_KEY_NOTES_IDX, licenseKeyDetails.licenseKeyNotes);
    }

    private static void populateCustomLabels(ArrayList<Object> licenseKeyDetailsProps, KeyAnyValue[] customLabels) {
        LinkedHashMap<String, String> customLabelsMap = new LinkedHashMap<String, String>();
        for (KeyAnyValue customLabel : customLabels) {
            customLabelsMap.put(customLabel.getKey(), (String)customLabel.getValue());
        }
        licenseKeyDetailsProps.add(JsonLicenseKeyDetailsConstants.CUSTOM_LABELS_IDX, customLabelsMap);
    }

    private static void populateOrderDetails(ArrayList<Object> licenseKeyDetailsProps, OrderDetails[] ordersDetails) {
        ArrayList ordersDetailsList = new ArrayList();
        for (OrderDetails orderDetails : ordersDetails) {
            ArrayList<Object> orderDetailsList = new ArrayList<Object>();
            orderDetailsList.add(JsonLicenseKeyDetailsConstants.ORDER_TYPE_IDX, orderDetails.type);
            orderDetailsList.add(JsonLicenseKeyDetailsConstants.ORDER_NUMBER_IDX, orderDetails.number);
            orderDetailsList.add(JsonLicenseKeyDetailsConstants.ORDER_QUANTITY_IDX, String.valueOf(orderDetails.orderQuantity));
            orderDetailsList.add(JsonLicenseKeyDetailsConstants.ORDER_DATE_IDX, orderDetails.orderDate);
            orderDetailsList.add(JsonLicenseKeyDetailsConstants.ORDER_PO_NUMBER_IDX, orderDetails.poNumber);
            ordersDetailsList.add(orderDetailsList);
        }
        licenseKeyDetailsProps.add(JsonLicenseKeyDetailsConstants.ORDER_DETAILS_IDX, ordersDetailsList);
    }

    private static void populateContractDetails(ArrayList<Object> licenseKeyDetailsProps, ContractDetails[] contractsDetails) {
        ArrayList contractsDetailsList = new ArrayList();
        for (ContractDetails contractDetails : contractsDetails) {
            ArrayList<Object> contractDetailsList = new ArrayList<Object>();
            contractDetailsList.add(JsonLicenseKeyDetailsConstants.CONTRACT_TYPE_IDX, contractDetails.type);
            contractDetailsList.add(JsonLicenseKeyDetailsConstants.CONTRACT_NUMBER_IDX, contractDetails.number);
            contractDetailsList.add(JsonLicenseKeyDetailsConstants.CONTRACT_LICENSE_COVERAGE_START_DATE_IDX, contractDetails.licenseCoverageStartDate);
            contractDetailsList.add(JsonLicenseKeyDetailsConstants.CONTRACT_LICENSE_COVERAGE_END_DATE_IDX, contractDetails.licenseCoverageEndDate);
            contractDetailsList.add(JsonLicenseKeyDetailsConstants.CONTRACT_SUPPORT_LEVEL_IDX, contractDetails.supportLevel);
            contractDetailsList.add(JsonLicenseKeyDetailsConstants.CONTRACT_ELA_FLAG_IDX, contractDetails.ELAFlag);
            contractsDetailsList.add(contractDetailsList);
        }
        licenseKeyDetailsProps.add(JsonLicenseKeyDetailsConstants.CONTRACT_DETAILS_IDX, contractsDetailsList);
    }
}

